#python

# Select Solo
# Author MODO JAPAN GROUP
# version 1.1


import sys
import lx

sel_groupName = 'mjg_sel_solo_group'


#################################################################
# Function to check whether there is group 'mjg_sel_solo_group'
#		group_id : exist ;  null : not exist
#################################################################
def GetGroupID():

	group_id = ''

	# get item number in current scene
	item_num = lx.eval( 'query sceneservice item.N ?' )

	# scan all items
	for i in range( 0, item_num ):

		# check type for each item
		item_type = lx.eval( "query sceneservice item.type ? %d" % i )

		# if type is group
		if ( item_type == 'group' ):

			item_name = lx.eval( 'query sceneservice item.name ? %d' % i )

			if( item_name == sel_groupName ):
				group_id = lx.eval( 'query sceneservice item.id ? %d' % i )
				i = item_num

	return group_id



#################################################################
#	Main function
#################################################################

# get arguments
argsAsString = lx.arg()

# set argument to 'solo' if arg string is empty
if ( argsAsString == '' ) :
	argsAsString = 'solo'

# turn off "Auto Hide Child Items"
lx.eval( 'pref.value application.autoHide false' )

# get item number in current scene
item_num = lx.eval( 'query sceneservice item.N ?' )

# get group id for this script's unique group
group_id = GetGroupID()

# variables for storing current selected meshes
select_ids = []

# "back" : back visibility state
if ( argsAsString == 'back' ) :

	# if there is this script's unique group
	if ( group_id ) :

		for i in range( 0, item_num ):

			# check type for each item
			com_string = "query sceneservice item.type ? " + str( i )
			item_type = lx.eval( com_string )

			# work only with mesh item
			if ( item_type == 'mesh' ) :

				# get item id
				item_id = lx.eval( 'query sceneservice item.id ? %d' % i )

				# turn off visibility for all meshes
				lx.eval( 'layer.setVisibility %s false' % item_id )

				# store current selected meshes
				sel_state = lx.eval( 'query sceneservice item.isSelected ?' )
				if( sel_state ):
					select_ids.append( item_id )

		# get stored mesh items' ids in the group
		lx.eval( 'select.item %s set' % group_id )
		storeItems = lx.evalN( 'query sceneservice group.itemMembers ? %s' % group_id )

		if( storeItems ) :

			for storeItem in storeItems :

				# turn on visibility
				item_id = lx.eval( 'query sceneservice item.id ? %s' % storeItem )
				lx.eval( 'layer.setVisibility %s true' % item_id )

			# delete group
			lx.eval( '!item.delete group' )

		# re-select
		for sid in select_ids :
			lx.eval( 'select.subItem %s add mesh 0 0' % sid )

else :

	visible_ids = []

	for i in range( 0, item_num ):

		# check type for each item
		com_string = 'query sceneservice item.type ? ' + str( i )
		item_type = lx.eval( com_string )

		# work only with mesh item
		if ( item_type == 'mesh' ) :

			# get item id
			com_string = 'query sceneservice item.id ? ' + str( i )
			item_id = lx.eval( com_string )

			# check select state for each item
			sel_state = lx.eval( 'query sceneservice item.isSelected ?' )
			if( sel_state ):
				select_ids.append( item_id )

			# "solo" : visible for selected item(s)
			if( argsAsString == 'solo' ):

				# store current visible meshes
				visible_state = lx.eval( 'query layerservice layer.visible ? %s' % item_id )
				if( visible_state != 'none' ):
					visible_ids.append( item_id )

				if( sel_state ) :
					lx.eval( 'layer.setVisibility %s true' % item_id )
				else :
					lx.eval( 'layer.setVisibility %s false' % item_id )

			# "reverse" : reverse visibility state
			elif( argsAsString == 'reverse' ):

				if( sel_state ) :
					lx.eval( 'layer.setVisibility %s false' % item_id )
				else :
					lx.eval( 'layer.setVisibility %s true' % item_id )

			# "all" : visible for all items
			elif( argsAsString == 'all' ):

				lx.eval( 'layer.setVisibility %s true' % item_id )

	# if there is unique group, delete it
	if ( group_id ) :
		lx.eval( 'select.item %s set' % group_id )
		lx.eval( '!item.delete group' )

	if( argsAsString == 'solo' ):

		# create unique group
		lx.eval( '!group.create %s std empty' % sel_groupName )

		# store last visible meshes into the group
		item_id = lx.eval( 'query sceneservice item.id ? first' )
		for vid in visible_ids :
			lx.eval( 'select.subItem %s set mesh 0 0' % vid )
			lx.eval( '!group.edit add item' )
			lx.eval( 'select.subItem %s remove mesh 0 0' % vid )

	# re-select
	for sid in select_ids :
		lx.eval( 'select.subItem %s add mesh 0 0' % sid )

# turn on "Auto Hide Child Items"
lx.eval( 'pref.value application.autoHide true' )





