#python

# Toggle Cage Setting
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

# get arguments
argsAsString = lx.arg()

# set argument to 'solo' if arg string is empty
if ( argsAsString == '' ) :
	argsAsString = 'true'

# variables for storing current selected meshes
selitems = lx.evalN( "query sceneservice selection ? all" )
selitemsnum = len( selitems )

# get item number in current scene
itemsNum = lx.eval( 'query sceneservice Item.N ?' )

# get mesh item information
for i in range ( itemsNum ) :

	com_string = 'query sceneservice item.type ? ' + str( i )
	item_type = lx.eval( com_string )

	if ( item_type == 'mesh' ) :

		com_string = 'query sceneservice item.id ? ' + str( i )
		item_id = lx.eval( com_string )

		com_string = 'select.subItem ' + item_id + ' set mesh'
		lx.eval( com_string )

		com_string = 'mesh.subdivCage ' + argsAsString
		lx.eval( com_string )

# reverse selection
if( selitemsnum > 0 ) :

	com_string = 'select.subItem ' + selitems[ 0 ] + ' set mesh;replicator;meshInst;camera;light;txtrLocator;backdrop;groupLocator;replicator;surfGen;locator;falloff;deform;locdeform;weightContainer;deformGroup;deformMDD2;ABCStreamingDeformer;morphDeform;itemInfluence;genInfluence;deform.push;deform.wrap;softLag;aaOceanBSDDeform;ABCCurvesDeform.sample;ABCdeform.sample;force.root;baseVolume;chanModify;itemModify;meshoperation;chanEffect;defaultShader;defaultShader 0 0'
	lx.eval( com_string )

	if( selitemsnum > 1 ) :

		for i in range ( 1, selitemsnum ) :

			com_string = 'select.subItem ' + selitems[ i ] + ' add mesh;replicator;meshInst;camera;light;txtrLocator;backdrop;groupLocator;replicator;surfGen;locator;falloff;deform;locdeform;weightContainer;deformGroup;deformMDD2;ABCStreamingDeformer;morphDeform;itemInfluence;genInfluence;deform.push;deform.wrap;softLag;aaOceanBSDDeform;ABCCurvesDeform.sample;ABCdeform.sample;force.root;baseVolume;chanModify;itemModify;meshoperation;chanEffect;defaultShader;defaultShader 0 0'
			lx.eval( com_string )

