#python

import modo,lx,math

#-------------------------------------------------
scene=modo.Scene()
mesh=scene.selectedByType('mesh')[0]
geo=mesh.geometry
#-------------------------------------------------
edge=geo.edges.selected
vert=geo.vertices
#-------------------------------------------------
def set_egde(e):

	e=edge
	
	if len(e) <> 2 and len(e) <> 3 :

		return None

	try:
		
		vert=[]
		edge_set=[]
	
		for i in e:
			
			for n in i.vertex_indices:
			
				vert.append(n)
		
		t=set()
		
		dup_vert=[i for i in vert if i in t or t.add(i)]
			
		[vert.remove(dup_vert[0]) for i in vert]
		
		for i in vert:
			
			n=(dup_vert[0],i)
			
			edge_set.append(n)
			
		return edge_set
	
	except:
		
		return None
		
#-------------------------------------------------
def create_vector(p1,p2):
	
	x1=p1[0]
	y1=p1[1]
	z1=p1[2]
	x2=p2[0]
	y2=p2[1]
	z2=p2[2]
	
	vx=x2-x1
	vy=y2-y1
	vz=z2-z1
	
	l=math.sqrt(vx*vx+vy*vy+vz*vz)
	
	return (vx,vy,vz),l

#-------------------------------------------------
def center2point(p1,p2):
	
	x1=p1[0]
	y1=p1[1]
	z1=p1[2]
	x2=p2[0]
	y2=p2[1]
	z2=p2[2]
	
	vx=(x2+x1)/2
	vy=(y2+y1)/2
	vz=(z2+z1)/2
	
	return vx,vy,vz

#-------------------------------------------------	
edges=set_egde(edge)
vector_set=[]
#-------------------------------------------------

if edges <> None:
	
	#-------------------------------------------------
	for i in edges:
		
		p1=vert[i[0]].position
		p2=vert[i[1]].position
	
		vector_set.append(create_vector(p1,p2))
	#-------------------------------------------------

	v1=modo.mathutils.Vector3(vector_set[0][0]).normal()
	v2=modo.mathutils.Vector3(vector_set[1][0]).normal()
	v3=modo.mathutils.Vector3.cross(v1,v2)

	#-------------------------------------------------
	
	M=modo.mathutils.Matrix3([v1,v2,v3]) 
	Q=modo.mathutils.Quaternion()
	Q.fromMatrix3(M)
	M=Q.toMatrix4()
	
	M4=mesh.channel('wrotMatrix').get()
	M4=modo.Matrix4(M4)
	
	M=M*M4
	
	E=M.asEuler(False,'zxy')
	
	#-------------------------------------------------

	p1=vert[edges[0][1]].position
	p2=vert[edges[1][1]].position
	
	p1=modo.Vector3(p1)
	p2=modo.Vector3(p2)
	p1.mulByMatrixAsPoint(M4)
	p2.mulByMatrixAsPoint(M4)
	
	center=modo.Vector3(center2point(p1,p2))

	M4=mesh.channel('wposMatrix').get()
	M4=modo.Matrix4(M4)	
		
	offset_pos=modo.Vector3(M4.position)
	
	center = center + offset_pos	

	#-------------------------------------------------
	#-------------------------------------------------
	
	try:
		
		lx.eval('!preset.do')

		#-------------------------------------------------
		tg_mesh=scene.selectedByType('mesh')[0]
		
		Offset_W = (round(vector_set[0][1],4)-1.0) / 2
		Offset_H = (round(vector_set[1][1],4)-1.0) / 2
		
		print Offset_W
		
		#-------------------------------------------------
		
		lx.eval('select.type vertex')
		lx.eval('select.useSet Sash_L replace')		
		geo=tg_mesh.geometry
		vert=geo.vertices.selected
			
		for i in vert:
			
			i.x -= Offset_W	
		
		geo.setMeshEdits()
		
		#-------------------------------------------------

		lx.eval('select.useSet Sash_R replace')		
		geo=tg_mesh.geometry
		vert=geo.vertices.selected
		
		for i in vert:
			
			i.x += Offset_W	
		
		geo.setMeshEdits()		

		#-------------------------------------------------

		lx.eval('select.useSet Sash_B replace')		
		geo=tg_mesh.geometry
		vert=geo.vertices.selected
		
		for i in vert:
			
			i.y -= Offset_H
		
		geo.setMeshEdits()	

		#-------------------------------------------------

		lx.eval('select.useSet Sash_T replace')		
		geo=tg_mesh.geometry
		vert=geo.vertices.selected
		
		for i in vert:
			
			i.y += Offset_H
		
		geo.setMeshEdits()	
		
		if len(vector_set)==3:
			
			Offset_Z = round(vector_set[2][1],4) - 0.15
			
			lx.eval('select.useSet Sash_D replace')		
			geo=tg_mesh.geometry
			vert=geo.vertices.selected
			
			for i in vert:
				
				i.z -= Offset_Z
			
			geo.setMeshEdits()		
								
		#-------------------------------------------------
		tg_mesh.position.set(center)
		tg_mesh.rotation.set(E,degrees=False)
		#-------------------------------------------------
		
		lx.eval('select.drop vertex')
		lx.eval('select.type edge')

		mesh.select(1)
				
	except:
		
		print 'Preset Error'

	#-------------------------------------------------
	print 'X_Length = %s' %(round(vector_set[0][1],4))
	print 'Y_Length = %s' %(round(vector_set[1][1],4))
	
	if len(vector_set)==3:
		
		print 'Z_Length = %s' %(round(vector_set[2][1],4))
	
	else:
		
		print 'Z_Length = None'
	#-------------------------------------------------

else:
	
	print 'select error'

