#python

# Select Skeleton Weight from Skeleton
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

#################################################################
# Function to check whether specified weight exists or not
#		return 1 (exist) : 0 (no exist)
#################################################################
def IsExistWeight( wgt_num, wgt_names, target_wgt ) :

	for i in range( 0, wgt_num ) :

		if( wgt_names[ i ] == target_wgt ) :
			return 1

	return 0


#################################################################
#	Main function
#################################################################
skweight = []
sknum = 0

# Get Weight  Information
weight_num = lx.eval( "query layerservice vmap.N ? weight" )

if weight_num != 0:

    # Create Weight Map Name Lists
	wgt_maps = lx.eval( "query layerservice vmaps ? weight" )
	wgt_names = []

	for each_map in wgt_maps:

		com_string = "query layerservice vmap.name ? " + each_map
		map_name = lx.eval( com_string )
		wgt_names.append( map_name )


# Get Skeleton (=pureLocators) Info
pureLocators = lx.eval( "query sceneservice pureLocators ? ")

for pL in pureLocators:

    # Check whether the skeleton is selected or not
    com_string = "query sceneservice item.isSelected ? " + pL
    isSelected = lx.eval( com_string )
    
    if ( isSelected ) :

        # Get Skeleton Name
        com_string = "query sceneservice item.id ? " + pL
        ske_name = lx.eval( com_string )

        # Create weight name from locator(skeleton) name
        wgt_name = "__item_" + ske_name

        if ( IsExistWeight( weight_num, wgt_names, wgt_name ) ) :
            skweight.append( wgt_name )
            sknum += 1

# Select Skeleton Weight
for i in range( 0, sknum ):

    if ( i == 0 ) :
        com_string = "select.vertexMap " + skweight[ i ] + " wght replace"
    else :
       com_string = "select.vertexMap " + skweight[ i ] + " wght add"

    lx.eval( com_string )

