#python

# Replace Mesh Layer
# Author MODO JAPAN GROUP
# version 1.1

import sys
import lx

str_chan = [ 'pos.X', 'pos.Y', 'pos.Z', 'rot.X', 'rot.Y', 'rot.Z', 'scl.X', 'scl.Y', 'scl.Z' ]
str_xfrm = [ 'xfrmPos', 'xfrmRot', 'xfrmScl' ]
str_chan2 = [ 'pos', 'rot', 'scl' ]

sel_items = []

# Get arguments = Parameter
#argsAsString = lx.arg()

#if ( argsAsString == '1' ) :
#	use_instance = 1
#else :
#	use_instance = 0

mesh_lists = []
mesh_ids = []

list_string = 'user.def mjg_dest_item list "'

item_num = lx.eval( "query sceneservice item.N ?" )

for i in range( 0, item_num):

	# get item's display name, type, internal name, tagType
	com_string = "query sceneservice item.type ? " + str( i )
	item_type = lx.eval( com_string )

	if( item_type == 'mesh' ):

		com_string = "query sceneservice item.id ? " + str( i )
		item_id = lx.eval( com_string )
		mesh_ids.append( item_id )

		com_string = "query sceneservice item.name ? " + str( i )
		lx.out( com_string )
		item_name = lx.eval( com_string )
		mesh_lists.append( item_name )
		list_string += item_name + ';'

#com_string = 'user.value mjg_dest_item list ' + mesh_listsists
list_string += '"'
lx.eval( list_string )
lx.out( list_string )

use_instance = lx.eval( 'user.value mjg_use_instance ?' )
dest_item = lx.eval( 'user.value mjg_dest_item ?' )

# Switch Edit Mode
lx.eval( "select.typeFrom polygon;edge;vertex;item;pivot;center;ptag true" )

# Get Replace Source ID
sel_items = lx.evalN( "query sceneservice selection ? mesh" )
sel_num = len( sel_items )

#lx.out( sel_items )

# Get Replace Dest ID
dest_item = sel_items[ sel_num - 1 ]

#lx.out( dest_item )

com_string = "select.subItem " + dest_item + " set mesh 0 0"
lx.eval( com_string )

if ( use_instance == 0 ) :

	# Reference System on
	com_string = "item.refSystem " + dest_item
	lx.eval( com_string )

	# Copt Dest geometry
	lx.eval( "copy" )

	for i in range( 0, sel_num - 1 ):

		com_string = "select.subItem " + sel_items[ i ] + " set mesh 0 0"
		lx.eval( com_string )

		com_string = "item.refSystem " + sel_items[ i ]
		lx.eval( com_string )

		lx.eval( "select.delete" )

		lx.eval( "paste" )

	# Reference System off
	lx.eval( "item.refSystem {}" )

	com_string = "select.subItem " + sel_items[ 0 ] + " set mesh 0 0"
	lx.eval( com_string )

	for i in range( 1, sel_num ) :

		com_string = "select.subItem " + sel_items[ i ] + " add mesh 0 0"
		lx.eval( com_string )

else :

	for i in range( 0, sel_num - 1 ):

		# Select Dest item and make instance
		com_string = "select.subItem " + dest_item + " set mesh 0 0"
		lx.eval( com_string )

		lx.eval( "item.duplicate true locator false true" )

		inst_item = lx.eval( "query sceneservice selection ? meshInst" )

		# Set parent same as Dest item
		com_string = "query sceneservice item.parent ? " + sel_items[ i ]
		mesh_parent = lx.eval( com_string )

		if ( mesh_parent ) :

			com_string = "select.subItem " + mesh_parent + " add mesh 0 0"
			lx.eval( com_string )

			lx.eval( "item.parent type:xfrmcore" )

		for xfrm_index in range( 0, 3 ) :

			# Channel Copy : xfrmPos -> 0 ; xfrmRot -> 1 ; xfrmScl -> 2 ;
			com_string = "query sceneservice item." + str_xfrm[ xfrm_index ] + " ? " + sel_items[ i ]
			lx.eval( com_string )
			chn_src_id = lx.eval( com_string )

			com_string = "query sceneservice item." + str_xfrm[ xfrm_index ] + " ? " + inst_item
			lx.eval( com_string )
			chn_dest_id = lx.eval( com_string )

			if ( chn_src_id ) :

				if ( not chn_dest_id ) :

					com_string = "transform.add " + str_chan2[ xfrm_index ] + " " + inst_item + " adv:1"
					lx.eval( com_string )

					com_string = "query sceneservice item." + str_xfrm[ xfrm_index ] + " ? " + inst_item
					chn_dest_id = lx.eval( com_string )

				for chan_index in range( 0, 3 ) :

					j = xfrm_index * 3 + chan_index

					com_string = "select.subItem " + sel_items[ i ] + " set mesh 0 0"
#					lx.out( com_string )
					lx.eval( com_string )

					com_string = "select.channel {" + chn_src_id + ":" + str_chan[ j ] + "} set"
#					lx.out( com_string )
					lx.eval( com_string )

					lx.eval( "channel.copy" )

					com_string = "select.subItem " + inst_item + " set mesh 0 0"
#					lx.out( com_string )
					lx.eval( com_string )

					com_string = "select.channel {" + chn_dest_id + ":" + str_chan[ j ] + "} set"
#					lx.out( com_string )
					lx.eval( com_string )

					lx.eval( "channel.paste" )

			else :

				if ( chn_dest_id ) :

					com_string = "select.subItem " + inst_item + " set mesh 0 0"
					lx.eval( com_string )

					com_string = "select.item " + chn_dest_id + " set transform"
					lx.eval( com_string )

					lx.eval( "item.delete" )

		com_string = "select.subItem " + sel_items[ i ] + " set mesh 0 0"
		lx.eval( com_string )
		lx.eval( "delete" )

		lx.eval( "select.drop item" )

