﻿#python

# Move Selected Points' Position to Last Selected Point's one
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

# get arguments
argsAsString = lx.arg()

# If EditMode is vertex
if lx.eval( 'select.typeFrom vertex;edge;polygon;item;pivot;center;ptag ?' ):

	vert_selnum = lx.eval( 'query layerservice vert.N ? selected' )
	verts = lx.evalN( 'query layerservice verts ? selected' )

	if verts:

		# Get Last Selected Point's Position
		targetx, targety, targetz = lx.eval( 'query layerservice vert.pos ? %s' % verts[ vert_selnum - 1 ] )

		for vertID in verts :

			# Get Point Index Number
			vid = lx.eval( 'query layerservice vert.index ? %s' % vertID )

			if ( argsAsString == 'x' ) :

				lx.eval( 'vertMap.setVertex position position 0 %s %f' % ( vid, targetx ) )

			elif ( argsAsString == 'y' ) :

				lx.eval( 'vertMap.setVertex position position 1 %s %f' % ( vid, targety ) )

			elif ( argsAsString == 'z' ) :

				lx.eval( 'vertMap.setVertex position position 2 %s %f' % ( vid, targetz ) )

			else :

				lx.eval( 'vertMap.setVertex position position 0 %s %f' % ( vid, targetx ) )
				lx.eval( 'vertMap.setVertex position position 1 %s %f' % ( vid, targety ) )
				lx.eval( 'vertMap.setVertex position position 2 %s %f' % ( vid, targetz ) )

