﻿#python

# Move Center to Selected Elements
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

# Get Edit Type
editType = 'notComponent'

centerX = 0.0
centerY = 0.0
centerZ = 0.0

selElement = 0
layerIndex = 0

# If EditMode is vertex
if lx.eval( 'select.typeFrom vertex;edge;polygon;item;pivot;center;ptag ?' ):

	layerIndex = lx.eval( 'query layerservice vert.layer ? first' )

	vert_selnum = lx.eval( 'query layerservice vert.N ? selected' )
	verts = lx.evalN( 'query layerservice verts ? selected' )

	if verts:

		for vertID in verts :

			vx, vy, vz = lx.eval( 'query layerservice vert.pos ? %s' % vertID )
			centerX += vx
			centerY += vy
			centerZ += vz

		centerX /= vert_selnum
		centerY /= vert_selnum
		centerZ /= vert_selnum

		selElement = 1

	editType = 'vertex'

# If EditMode is edge
elif lx.eval( 'select.typeFrom edge;vertex;polygon;item;pivot;center;ptag ?' ):

	layerIndex = lx.eval( 'query layerservice edge.layer ? first' )

	edge_selnum = lx.eval( 'query layerservice edge.N ? selected' )
	edges = lx.evalN( 'query layerservice edges ? selected' )

	if edges:

		for edgeID in edges :

			vx, vy, vz = lx.eval( 'query layerservice edge.pos ? %s' % edgeID )
			centerX += vx
			centerY += vy
			centerZ += vz

		centerX /= edge_selnum
		centerY /= edge_selnum
		centerZ /= edge_selnum

		selElement = 1

	editType = 'edge'

# If EditMode is polygon
elif lx.eval( 'select.typeFrom polygon;edge;vertex;item;pivot;center;ptag ?' ):

	layerIndex = lx.eval( 'query layerservice poly.layer ? first' )

	poly_selnum = lx.eval( 'query layerservice poly.N ? selected' )
	polys = lx.evalN( 'query layerservice polys ? selected' )

	if polys:

		for polyID in polys :

			vx, vy, vz = lx.eval( 'query layerservice poly.pos ? %s' % polyID )
			centerX += vx
			centerY += vy
			centerZ += vz

		centerX /= poly_selnum
		centerY /= poly_selnum
		centerZ /= poly_selnum

		selElement = 1

	editType = 'polygon'

# If Editmode is 'Component' mode
if ( editType != 'notComponent' ) :

	# Get item id of center
	selMesh = lx.eval( 'query sceneservice item.id ? %s' % layerIndex )

	# If there is no element selected
	if not selElement :

		# Get info of bounding box
		bx1, by1, bz1, bx2, by2, bz2 = lx.eval( 'query layerservice layer.bounds ?' )
		centerX = ( bx1 + bx2 ) / 2.0
		centerY = ( by1 + by2 ) / 2.0
		centerZ = ( bz1 + bz2 ) / 2.0

	# Switch to Center mode
	lx.eval( 'item.componentMode center true' )

	# Select Center
	lx.eval( 'select.center %s set' % selMesh )

	# Set Center Position
	lx.eval( 'center.setPosition %f %f %f' % ( centerX, centerY, centerZ ) )

	# Switch to Component mode
	lx.eval( 'item.componentMode %s true' % editType )

