﻿#python

# Mirror Weight for Skeleton Weight
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

#str_source = "_L"
#str_dest = "_R"

str_source = lx.eval( 'user.value mjg_mirror_skweight.str_source ?' )
str_dest = lx.eval( 'user.value mjg_mirror_skweight.str_dest ?' )


#################################################################
# Function to get Mirroed locator index for specified skeleton name
#		return locator index
#################################################################
def GetMirroredIndex( index, sknum, skeleton_names ) :

	sk_src = skeleton_names[ index ]
	sk_dest = sk_src.replace( str_source, str_dest )
	lx.out( sk_src, sk_dest )

	for i in range ( 0, sknum ) :

		if( skeleton_names[ i ] == sk_dest ):
			return i

	return -1


#################################################################
# Function to check whether specified weight exists or not
#		return 1 (exist) : 0 (no exist)
#################################################################
def IsExistWeight( wgt_num, wgt_names, target_wgt ) :

	for i in range( 0, wgt_num ) :

		if( wgt_names[ i ] == target_wgt ) :
			return 1

	return 0


#################################################################
#	Main function
#################################################################

# get symmetry state
sym_state = lx.eval( "symmetry.state ?" )
lx.out( sym_state )

if( sym_state == 0 ) :

	lx.eval( "symmetry.state true" )

# get item number in current scene
item_num = lx.eval( "query sceneservice item.N ?" )

# locator_names : locator display name
#			ex: Skeleton_Joint, Skeleton_Joint (2), ...
# locator_ids : locator internal name
#			ex : locator022, locator024, ...
locator_names = []
locator_ids = []
locator_sel = []
locator_num = 0

# scan all items in scene
for i in range( 0, item_num):

	# get item's display name, type, internal name, tagType
	str_count = str( i )
	com_string = "query sceneservice item.name ? " + str_count
	item_name = lx.eval( com_string )
	com_string = "query sceneservice item.type ? " + str_count
	item_type = lx.eval( com_string )
	com_string = "query sceneservice item.id ? " + str_count
	item_id = lx.eval( com_string )
	com_string = "query sceneservice item.tagTypes ? " + str_count
	item_tag = lx.eval( com_string )

	if ( item_type== "locator" ):

		# get locator display names and internal names in scene
		locator_names.append( item_name )
		locator_ids.append( item_id )

		com_string = "query sceneservice item.isSelected ? " + str_count
		item_sel = lx.eval( com_string )
		locator_sel.append( item_sel )

		locator_num += 1

#lx.out( "locator number = %d" % locator_num )
#lx.out( "locator name = %s" % locator_names )
#lx.out( "locator id = %s" % locator_ids )
#lx.out( "locator sel = %s" % locator_sel )

### Get Weight  Information ###

weight_num = lx.eval( "query layerservice vmap.N ? weight" )

if weight_num != 0:

    # Create Weight Map Name Lists
	wgt_maps = lx.eval( "query layerservice vmaps ? weight" )
	wgt_names = []

	for each_map in wgt_maps:

		com_string = "query layerservice vmap.type ? " + each_map
		map_type = lx.eval( com_string )
		com_string = "query layerservice vmap.name ? " + each_map
		map_name = lx.eval( com_string )
		wgt_names.append( map_name )

#	lx.out( "weight number = %d" % weight_num )
#	lx.out( "wgt_names = %s" % wgt_names )


###  ###

for i in range( 0, locator_num ):

	# Do for selected items
	if ( locator_sel[ i ] == 1 ):

		# Get Skeleton Weight Name
		skweight_source = "__item_" + locator_ids[ i ]
#		lx.out( skweight_source )

		# Get Mirrored Skeleton and its Weight Name
		mirror_index = GetMirroredIndex( i, locator_num, locator_names )
		if( mirror_index != -1 ) :

			skweight_dest = "__item_" + locator_ids[ mirror_index ]
#			lx.out( skweight_dest )

			if ( IsExistWeight( weight_num, wgt_names, skweight_source ) and IsExistWeight( weight_num, wgt_names, skweight_dest )):

				# Select Skeleton Weight and Mirror
				com_string = "select.vertexMap " + skweight_source + " wght replace"
				lx.eval( com_string )

				com_string = "vertMap.mirror " + skweight_source + " " + skweight_dest
				lx.eval( com_string )

# revert symmetry state
if( sym_state == 0 ) :

	lx.eval( "symmetry.state false" )

