#python
import lx

main = lx.eval1('query sceneservice selection ? mesh')
currentMesh = lx.eval('query layerservice layers ? %s' %main)

def calculate_pos(edge_id):
	
	id=edge_id[0] + ',' + edge_id[1]
	
	length=lx.eval('query layerservice edge.length ? %s' %(id))
	vector=lx.eval('query layerservice edge.vector ? %s' %(id))
	
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[0])
	x1=pos[0]
	y1=pos[1]
	z1=pos[2]
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[1])
	x2=pos[0]
	y2=pos[1]
	z2=pos[2]
	
	vx=x2-x1
	vy=y2-y1
	vz=z2-z1
	
	ex=vx/length
	ey=vy/length
	ez=vz/length
	
	try:
		k=(a*x1+b*y1+c*z1+d)*-1/(a*ex+b*ey+c*ez)
	
		tx=x1+k*ex
		ty=y1+k*ey
		tz=z1+k*ez
	
		return tx,ty,tz

	except:

		return False
		
#----------------------------------------------------------------------	
#----------------------------------------------------------------------	
def calculate_normal(P):
	
	p1=P[0]
	p2=P[1]
	p3=P[2]	

	Sx=p2[0]-p1[0]
	Sy=p2[1]-p1[1]
	Sz=p2[2]-p1[2]
	
	Tx=p3[0]-p1[0]
	Ty=p3[1]-p1[1]
	Tz=p3[2]-p1[2]
	
	STx=Sy*Tz-Sz*Ty
	STy=Sz*Tx-Sx*Tz
	STz=Sx*Ty-Sy*Tx
	
	volume=pow(STx*STx+STy*STy+STz*STz,0.5)
		
	a=STx/volume
	b=STy/volume
	c=STz/volume
	
	normal=(a,b,c)
	
	return normal
#----------------------------------------------------------------------------
#---------------------------------------------------------
polys = lx.evalN('query layerservice polys ? selected')
#----------------------------------------------------------------------------
#-main-----------------------------------------------------------------------
#----------------------------------------------------------------------------

lx.eval('item.refSystem %s' %main)

if len(polys)==2 and lx.eval('select.typeFrom {polygon;edge;vertex} ?')==1:

	#----------------------------------------------------------------------------
	#----------------------------------------------------------------------------
	verts = lx.eval('query layerservice poly.vertList ? %s' %polys[1])
	
	first_poly_nomal =lx.eval('query layerservice poly.normal ? %s' %polys[0])
	first_poly_vert = lx.eval('query layerservice poly.vertList ? %s' %polys[0])
	
	share_vert = set(verts) & set(first_poly_vert)
	share_vert=list(share_vert)
	
	share_pos=[]

	for i in share_vert:
		share_pos.append(lx.eval('query layerservice vert.pos ? %s' %i))
	
	if share_pos!=[]:
	
		add_vert_pos=[x+y for (x,y) in zip(share_pos[0],first_poly_nomal)]
	
		vert_set=(share_pos[0],share_pos[1],add_vert_pos)
	
		tg_poly_nomal = calculate_normal(vert_set)	
		tg_poly_pos = share_pos[0]
		
		#----------------------------------------------------------------------------
		
		lx.eval('select.element %s polygon set %s' %(currentMesh,polys[1]))
		lx.eval('select.convert edge')
		
		exclusion=[]
		
		#----------------------------------------------------------------------------
		for i in lx.eval('query layerservice edges ? selected'):
		
			exclusion.append(i)
		
		#----------------------------------------------------------------------------
		lx.eval('select.expand')
		
		#----------------------------------------------------------------------------
		for i in exclusion:
			
			i = i.strip('()').split(',')
			lx.eval('select.element %s edge remove %s %s' %(currentMesh,i[0],i[1]))
		#----------------------------------------------------------------------------
		
		edge = lx.eval('query layerservice edges ? selected')
		#----------------------------------------------------------------------------
		
		#-plane----------------------------------------------------------------------
		a=tg_poly_nomal[0]
		b=tg_poly_nomal[1]
		c=tg_poly_nomal[2]
		d=(a*tg_poly_pos[0]+b*tg_poly_pos[1]+c*tg_poly_pos[2])*-1
		#----------------------------------------------------------------------------
			
		for i in edge:
			
			i=i.strip('()').split(',')
		
			tg_pos=calculate_pos(i)
			
			if tg_pos==False:
				
				print 'Nothing'
			
			else:
			
				for n in verts:
				
					if str(n) in i:
					
						lx.eval('vertMap.setVertex position position 0 %s %s' %(n,tg_pos[0]))
						lx.eval('vertMap.setVertex position position 1 %s %s' %(n,tg_pos[1]))
						lx.eval('vertMap.setVertex position position 2 %s %s' %(n,tg_pos[2]))
		#----------------------------------------------------------------------------
		lx.eval('select.drop edge')	
		lx.eval('select.typeFrom polygon')
		#----------------------------------------------------------------------------
		#----------------------------------------------------------------------------	
		
		for i in polys:
			
			if i==polys[-1]:continue
			
			lx.eval('select.element %s polygon add %s' %(currentMesh,i))
	
	else:
		
		lx.eval('dialog.setup error')
		lx.eval('dialog.title Right_Angle_Poly.py')
		lx.eval('dialog.msg "@mihi_tools@select_consecutive_poly"')
		lx.eval('dialog.open')	
					
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------
else:
	
	lx.eval('dialog.setup error')
	lx.eval('dialog.title Right_Angle_Poly.py')
	lx.eval('dialog.msg "@mihi_tools@selectonly2poly"')
	lx.eval('dialog.open')	

#----------------------------------------------------------------------------
lx.eval('item.refSystem {}')	
#----------------------------------------------------------------------------