#python
import lx
#-------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------
def calc_vector(p1,p2):
	
	a=p2[0]-p1[0]
	b=p2[1]-p1[1]
	
	l=pow(a*a+b*b,0.5)
	
	a=a/l
	b=b/l

	return a,b,l
#-------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------	
def cross_product(v1,v2):
	
	return v1[1]*v2[0]-v1[0]*v2[1]
#-------------------------------------------------------------------------------------

def intersect(flg):
		
	if flg =='top' or flg == 'bot':
		
		axis_x=0
		axis_y=2
		
	elif	flg =='rgt' or flg == 'lft':
			
		axis_x=2
		axis_y=1
	
	elif flg == 'fnt' or flg == 'bck':
		
		axis_x=0
		axis_y=1
	
	else:
	
		return 'not_work_view'

	#-Line--------------------------------------------------------------------------------
	p1 = (vertPos[0][axis_x], vertPos[0][axis_y])
	p2 = (vertPos[1][axis_x],	vertPos[1][axis_y])
	p3 = (vertPos[2][axis_x],	vertPos[2][axis_y])
	p4 = (vertPos[3][axis_x],	vertPos[3][axis_y])

	v1=calc_vector(p1,p2)
	v2=calc_vector(p3,p4)
	
	n=round(cross_product(v1,v2),6)
	
	if n==0: return False

	#-Intersect----------------------------------------------------------------------------
	
	s=(p4[1]-p3[1])*(p4[0]-p1[0])-(p4[0]-p3[0])*(p4[1]-p1[1])
	t=(p2[0]-p1[0])*(p4[1]-p1[1])-(p2[1]-p1[1])*(p4[0]-p1[0])
	d=(p2[0]-p1[0])*(p4[1]-p3[1])-(p2[1]-p1[1])*(p4[0]-p3[0])
	
	r=s/d
	m=t/d
	
	x=p1[0]+r*(p2[0]-p1[0])
	y=p1[1]+r*(p2[1]-p1[1])
	
	return x,y

	#-------------------------------------------------------------------------------------

#-------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------
#-main------------------------------------------------------------------------------------	

main = lx.eval1('query sceneservice selection ? mesh')
currentLayer = lx.eval('query layerservice layers ? main')
edge = lx.evalN('query layerservice edges ? selected')

if len(edge) == 2:

	vert=[]
	vertPos=[]
	vertSet={}
	
	X=[]
	Y=[]
	Z=[]
	
	#----------------------------------------------------------------------------------
	for i in edge:
	
		vert = i.strip('()').split(',')
		
		#-------------------------------------------------------------------------------
		for n in vert:
			
			vertPos.append(lx.eval('query layerservice vert.Pos ? %s' %n))
			vertSet[n] = lx.eval('query layerservice vert.Pos ? %s' %n)
			
		#-------------------------------------------------------------------------------
	#----------------------------------------------------------------------------------
	
	view = lx.eval('view3d.projection ?')
	
	tg_pos = intersect('%s'%view)
	
	if tg_pos==False:	
		
		lx.eval("dialog.setup error")
		lx.eval("dialog.title Intersect_Edge_2d.py")
		lx.eval('dialog.msg "@mihi_tools@no_cross"')
		lx.eval("dialog.open")	
	
	elif tg_pos=='not_work_view':
	
		print 'view'
			
	else:
			
		flg = lx.args()
		
		if flg[0]=='0':
		
			if view =='top' or view == 'bot':
				
				lx.eval('tool.set prim.makeVertex on 0')
				lx.eval('tool.reset')
				lx.eval('tool.setAttr prim.makeVertex cenX %s' %tg_pos[0])
				lx.eval('tool.setAttr prim.makeVertex cenY 0')
				lx.eval('tool.setAttr prim.makeVertex cenZ %s' %tg_pos[1])
				lx.eval('tool.apply')
				lx.eval('tool.set prim.makeVertex off 0')
				
			elif	view =='rgt' or view == 'lft':
					
				lx.eval('tool.set prim.makeVertex on 0')
				lx.eval('tool.reset')
				lx.eval('tool.setAttr prim.makeVertex cenX 0')
				lx.eval('tool.setAttr prim.makeVertex cenY %s' %tg_pos[1])
				lx.eval('tool.setAttr prim.makeVertex cenZ %s' %tg_pos[0])
				lx.eval('tool.apply')
				lx.eval('tool.set prim.makeVertex off 0')
					
			elif view == 'fnt' or view == 'bck':
				
				lx.eval('tool.set prim.makeVertex on 0')
				lx.eval('tool.reset')
				lx.eval('tool.setAttr prim.makeVertex cenX %s' %tg_pos[0])
				lx.eval('tool.setAttr prim.makeVertex cenY %s' %tg_pos[1])
				lx.eval('tool.setAttr prim.makeVertex cenZ 0')
				lx.eval('tool.apply')
				lx.eval('tool.set prim.makeVertex off 0')
		
		elif flg[0]=='1':
					
			distance={}	
			
			if view =='top' or view == 'bot':
				
				for i in vertSet:			
					
					distance[int(i)]=(pow(pow(tg_pos[0]-vertSet[i][0],2)+pow(tg_pos[1]-vertSet[i][2],2),0.5))
				
				distance=sorted(distance.items(), key=lambda x:x[1])
				
				lx.eval('vertMap.setVertex position position 0 %s %s' %(distance[0][0],tg_pos[0]))
				lx.eval('vertMap.setVertex position position 2 %s %s' %(distance[0][0],tg_pos[1]))
				lx.eval('vertMap.setVertex position position 0 %s %s' %(distance[1][0],tg_pos[0]))
				lx.eval('vertMap.setVertex position position 2 %s %s' %(distance[1][0],tg_pos[1]))
			
			
			elif	view =='rgt' or view == 'lft':
				
				for i in vertSet:			
					
					distance[int(i)]=(pow(pow(tg_pos[0]-vertSet[i][2],2)+pow(tg_pos[1]-vertSet[i][1],2),0.5))
				
				distance=sorted(distance.items(), key=lambda x:x[1])
				
				lx.eval('vertMap.setVertex position position 2 %s %s' %(distance[0][0],tg_pos[0]))
				lx.eval('vertMap.setVertex position position 1 %s %s' %(distance[0][0],tg_pos[1]))
				lx.eval('vertMap.setVertex position position 2 %s %s' %(distance[1][0],tg_pos[0]))
				lx.eval('vertMap.setVertex position position 1 %s %s' %(distance[1][0],tg_pos[1]))	
							
			elif view == 'fnt' or view == 'bck':
			
				for i in vertSet:			
						
					distance[int(i)]=(pow(pow(tg_pos[0]-vertSet[i][0],2)+pow(tg_pos[1]-vertSet[i][1],2),0.5))
					
				distance=sorted(distance.items(), key=lambda x:x[1])
					
				lx.eval('vertMap.setVertex position position 0 %s %s' %(distance[0][0],tg_pos[0]))
				lx.eval('vertMap.setVertex position position 1 %s %s' %(distance[0][0],tg_pos[1]))
				lx.eval('vertMap.setVertex position position 0 %s %s' %(distance[1][0],tg_pos[0]))
				lx.eval('vertMap.setVertex position position 1 %s %s' %(distance[1][0],tg_pos[1]))		
				
				print distance[1][0]

#-------------------------------------------------------------------------------------
else:
	
	lx.eval('dialog.setup error')
	lx.eval('dialog.title Intersect_Edge_2d.py')
	lx.eval('dialog.msg "@mihi_tools@select2edge"')
	lx.eval('dialog.open')	

