#python
import lx

main = lx.eval1('query sceneservice selection ? mesh')
currentMesh = lx.eval('query layerservice layers ? %s' %main)
#---------------------------------------------------------------------
#---------------------------------------------------------------------
def edge_slide():
	Dist = lx.eval('user.value slide.distance ?')
	Axis = lx.eval('user.value slide.axis ?')
	
	if Axis==0:
		Axis='dirX'
	elif Axis==1:
		Axis='dirY'
	elif Axis==2:
		Axis='dirZ'
	
	lx.eval('select.editSet es_temp add {}')
	lx.eval('tool.set EdgeSlide on')
	lx.eval('tool.reset')
	lx.eval('tool.attr edge.slide mode linear')
	lx.eval('tool.attr edge.slide interpolation distance')
	lx.eval('tool.attr edge.slide duplicate true')
	lx.eval('tool.setAttr edge.slide %s %s' %(Axis,Dist))
	lx.eval('tool.attr edge.slide dist %s' %abs(Dist))
	lx.eval('tool.doApply')
	lx.eval('tool.set EdgeSlide off')
	lx.eval('select.useSet es_temp deselect')
	lx.eval('vertMap.deleteByName PICK es_temp')

#---------------------------------------------------------------------
#---------------------------------------------------------------------
edges = lx.evalN('query layerservice edges ? selected')

if edges<>None:

	lx.eval('select.convert vertx')
	verts = lx.evalN('query layerservice verts ? selected')
	verts=[int(i) for i in verts]
	
	vert2=[]
	vert3=[]
	poly=[]
	cutpoly=[]
	
	#---------------------------------------------------------------------
	for i in edges:
		
		poly.append(lx.evalN('query layerservice edge.polylist ? %s' %i))
	
	for i in poly:
		
		for n in i:
		
			cutpoly.append(n)
	
	cutpoly=list(set(cutpoly))
			
	#---------------------------------------------------------------------
	for i in verts:
		
		v = lx.evalN('query layerservice vert.vertList ? %s' %i)
		
		vert1=[]
		
		for n in v:
			
			if n in verts:
				
				vert1.append(n)
		
		if len(vert1)>=2:
			
			vert2.append(i)
		
	#---------------------------------------------------------------------	
	for i in vert2:
		
		v = lx.eval('query layerservice vert.numVerts ? %s' %i)
	
		if v==3:
			
			vert3.append(i)
	
	#---------------------------------------------------------------------	
	for i in vert3:
		
		lx.eval('select.element %s vertex remove %s' %(currentMesh,i))	
	
	#---------------------------------------------------------------------	
	edge_slide()
	
	lx.eval('select.drop polygon')
	
	for i in cutpoly:
		
		lx.eval('select.element %s polygon add %s' %(currentMesh,i))
	
	lx.eval('poly.split')
	lx.eval('select.typeFrom vertex;edge;polygon;item;pivot;center;ptag true')
	lx.eval('select.convert edge')
	#---------------------------------------------------------------------
	
	v=len(lx.evalN('query layerservice verts ? selected'))
	e=len(lx.evalN('query layerservice edges ? selected'))
		
	if v-1<>e:
		
		edges=lx.evalN('query layerservice edges ? selected')
		
		polys=[]
		vert4=[]
		#---------------------------------------------------------------------
		
		for i in edges:

			polys.append(lx.evalN('query layerservice edge.polylist ? %s' %i))
			
		lx.eval('select.typeFrom vertex;edge;2polygon;item;pivot;center;ptag true')
		lx.eval('select.editSet es_temp2 add {}')
		lx.eval('select.drop vertex')	
	
		for i in polys:
		
			for n in i:
			
				vert4.append(lx.eval('query layerservice poly.vertlist ? %s' %n))			
	
		vert5=[]
		
		for i in vert4:
			
			for n in i:
				
				vert5.append(n)	
		
		vert5=set(vert5)
	
		vert3=list(set(vert3) - vert5)
		#---------------------------------------------------------------------
		
		if vert3 <> []:
			
			for i in vert3:
				
				lx.eval('select.element %s vertex add %s' %(currentMesh, i))
			
			edge_slide()
			
			lx.eval('select.useSet es_temp2 select')
						
			lx.eval('select.typeFrom polygon;edge;vertex;item;pivot;center;ptag true')
			
			lx.eval('poly.split')
			lx.eval('select.typeFrom vertex;edge;polygon;item;pivot;center;ptag true')
			lx.eval('select.convert edge')
		#---------------------------------------------------------------------
		lx.eval('vertMap.deleteByName PICK es_temp2')
	#---------------------------------------------------------------------
	lx.eval('select.drop vertex')
	lx.eval('select.drop polygon')
	lx.eval('select.typeFrom edge;vertex;polygon;item;pivot;center;ptag true')
#---------------------------------------------------------------------
