#python
import modo

mesh = lx.eval1('query layerservice layer.id ? fg')
mesh = modo.Mesh(mesh)

#----------------------------------------------------------------
def shear(axis,height):
	
	lx.eval('tool.set xfrm.shear on')
	lx.eval('tool.reset')
	
	if axis == 0:
		
		if lx.eval('user.value shear.reverse ?') == 0:
			
			lx.eval('tool.setAttr falloff.linear startX %s' %min_x)
			lx.eval('tool.setAttr falloff.linear endX %s' %max_x)
		
		else:
		
			lx.eval('tool.setAttr falloff.linear startX %s' %max_x)
			lx.eval('tool.setAttr falloff.linear endX %s' %min_x)
		
		lx.eval('tool.setAttr falloff.linear startY 0')
		lx.eval('tool.setAttr falloff.linear endY 0')	
		lx.eval('tool.setAttr falloff.linear startZ 0')
		lx.eval('tool.setAttr falloff.linear endZ 0')	
						
	elif axis ==2:
		
		if lx.eval('user.value shear.reverse ?') == 0:
					
			lx.eval('tool.setAttr falloff.linear startZ %s' %min_z)
			lx.eval('tool.setAttr falloff.linear endZ %s' %max_z)		
			
		else:
			
			lx.eval('tool.setAttr falloff.linear startZ %s' %max_z)
			lx.eval('tool.setAttr falloff.linear endZ %s' %min_z)
							
		lx.eval('tool.setAttr falloff.linear startY 0')
		lx.eval('tool.setAttr falloff.linear endY 0')	
		lx.eval('tool.setAttr falloff.linear startX 0')
		lx.eval('tool.setAttr falloff.linear endX 0')	
				
	lx.eval('tool.attr xfrm.transform TY %s' %height)
	
	lx.eval('tool.doApply')
	lx.eval('tool.set xfrm.shear off')

#----------------------------------------------------------------


geo = mesh.geometry
poly = geo.polygons.selected

ix = []
iz = []

for i in poly:

	for n in i.vertices:
		
		ix.append(n.position[0])
		iz.append(n.position[2])

min_x = min(ix)
min_z = min(iz)
max_x = max(ix)
max_z = max(iz)

ix = max(ix) - min(ix)
iz = max(iz) - min(iz)

axis = lx.eval('user.value shear.axis ?')
slope = lx.eval('user.value shear.slope ?')

height = 0.0

if axis == 0:
	
	height = ix * slope * 0.1
	
	shear(0,height)
	
	print height


elif axis == 2:
	
	height = iz * slope * 0.1
	
	shear(2,height)
	
	print height

