#python
import lx

main = lx.eval1('query sceneservice selection ? mesh')
currentMesh = lx.eval('query layerservice layers ? %s' %main)

#----------------------------------------------------------------------------
#----------------------------------------------------------------------------
def calculate_pos(edge_id):
	
	id=edge_id[0] + ',' + edge_id[1]
	
	length=lx.eval('query layerservice edge.length ? %s' %(id))
	vector=lx.eval('query layerservice edge.vector ? %s' %(id))
	
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[0])
	x1=pos[0]
	y1=pos[1]
	z1=pos[2]
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[1])
	x2=pos[0]
	y2=pos[1]
	z2=pos[2]
	
	vx=x2-x1
	vy=y2-y1
	vz=z2-z1
	
	ex=vx/length
	ey=vy/length
	ez=vz/length
	
	try:
		k=(a*x1+b*y1+c*z1+d)*-1/(a*ex+b*ey+c*ez)
	
		tx=x1+k*ex
		ty=y1+k*ey
		tz=z1+k*ez
	
		return tx,ty,tz

	except:

		return False
		
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------	
#----------------------------------------------------------------------------
polys = lx.evalN('query layerservice polys ? selected')
#----------------------------------------------------------------------------
#-main-----------------------------------------------------------------------
#----------------------------------------------------------------------------

lx.eval('item.refSystem %s' %main)

if len(polys)>=2 and lx.eval('select.typeFrom {polygon;edge;vertex} ?')==1:

	#----------------------------------------------------------------------------
	#----------------------------------------------------------------------------
	for p in polys:
	
		if p==polys[-1]:continue
	
		verts = lx.eval('query layerservice poly.vertList ? %s' %p)
		tg_poly_nomal =lx.eval('query layerservice poly.normal ? %s' %polys[-1])
		tg_poly_pos = lx.eval('query layerservice poly.pos ? %s' %polys[-1])
		
		#----------------------------------------------------------------------------
		
		lx.eval('select.element %s polygon set %s' %(currentMesh,p))
		lx.eval('select.convert edge')
		
		exclusion=[]
		
		#----------------------------------------------------------------------------
		for i in lx.eval('query layerservice edges ? selected'):
		
			exclusion.append(i)
		
		#----------------------------------------------------------------------------
		lx.eval('select.expand')
		
		#----------------------------------------------------------------------------
		for i in exclusion:
			
			i = i.strip('()').split(',')
			lx.eval('select.element %s edge remove %s %s' %(currentMesh,i[0],i[1]))
		#----------------------------------------------------------------------------
		edge =[]
		edge = lx.eval('query layerservice edges ? selected')
		#----------------------------------------------------------------------------
		
		#-plane----------------------------------------------------------------------
		a=tg_poly_nomal[0]
		b=tg_poly_nomal[1]
		c=tg_poly_nomal[2]
		d=(a*tg_poly_pos[0]+b*tg_poly_pos[1]+c*tg_poly_pos[2])*-1
		#----------------------------------------------------------------------------

		if edge==None:continue
			
		for i in edge:
			
			i=i.strip('()').split(',')
		
			tg_pos=calculate_pos(i)
			
			if tg_pos==False:
				
				print 'Nothing'
			
			else:
			
				for n in verts:
				
					if str(n) in i:
					
						lx.eval('vertMap.setVertex position position 0 %s %s' %(n,tg_pos[0]))
						lx.eval('vertMap.setVertex position position 1 %s %s' %(n,tg_pos[1]))
						lx.eval('vertMap.setVertex position position 2 %s %s' %(n,tg_pos[2]))
		#----------------------------------------------------------------------------
		lx.eval('select.drop edge')	
		lx.eval('select.typeFrom polygon')
	#----------------------------------------------------------------------------
	#----------------------------------------------------------------------------	
	
	for i in polys:
		
		if i==polys[-1]:continue
		
		lx.eval('select.element %s polygon add %s' %(currentMesh,i))

#----------------------------------------------------------------------------
#----------------------------------------------------------------------------
else:
	
	lx.eval('dialog.setup error')
	lx.eval('dialog.title Poly_Fit_Planar.py')
	lx.eval('dialog.msg "@mihi_tools@select2poly"')
	lx.eval('dialog.open')	

#----------------------------------------------------------------------------
lx.eval('item.refSystem {}')	
#----------------------------------------------------------------------------

















	

	