#python

import modo, lx, math

#----------------------------------------------------------------------------------------
def create_vector(p1,p2,normal):

	x1=p1[0]
	y1=p1[1]
	z1=p1[2]
	x2=p2[0]
	y2=p2[1]
	z2=p2[2]
	
	x=x2-x1
	y=y2-y1
	z=z2-z1
	
	if normal==True:
	
		l=pow(x*x+y*y+z*z,0.5)
		
		if l <> 0:
			
			x=x/l
			y=y/l
			z=z/l
	
	v=modo.Vector3(x,y,z)

	return v

#----------------------------------------------------------------------------------------
def convert_world(p):

	M4=mesh.channel('wrotMatrix').get()
	M4=modo.mathutils.Matrix4(M4)
	M4.invert()
	
	Q=modo.mathutils.Quaternion()
	Q.fromMatrix4(M4)
	
	p=modo.Vector3(p)
	p.rotateByQuat(Q)
	
	pos=mesh.position.get()
	p+=pos
	
	return p

#----------------------------------------------------------------------------------------
def cross_point_3D(t1,t2):

	p1=list(t1.vertices[0].position)
	p2=list(t1.vertices[1].position)
	p1=convert_world(p1)
	p2=convert_world(p2)
			
	v1=create_vector(p1,p2,True)
	
	p1=list(t2.vertices[0].position)
	p2=list(t2.vertices[1].position)
	p1=convert_world(p1)
	p2=convert_world(p2)
			
	v2=create_vector(p1,p2,True)
	
	p1=t1.vertices[0].position
	p2=t2.vertices[0].position
	p1=convert_world(p1)
	p2=convert_world(p2)
		
	v3=create_vector(p1,p2,False)
	
	#----------------------------------------------------------------------------------------
	p1=modo.Vector3(t1.vertices[0].position)
	p2=modo.Vector3(t2.vertices[0].position)
	p1=convert_world(p1)
	p2=convert_world(p2)
	#----------------------------------------------------------------------------------------

	w1=modo.mathutils.Vector3.dot(v1,v2)
	w2=1-(w1*w1)

	if w2<>0:
	
		d1=(modo.Vector3.dot(v3,v1) - w1 * modo.Vector3.dot(v3,v2)) / w2
		d2=(w1 * modo.Vector3.dot(v3,v1) - modo.Vector3.dot(v3,v2)) / w2
		
		v1.setLength(d1)
		v2.setLength(d2)
		
		q1=p1+v1
		q2=p2+v2
		
		if (q2-q1)==(0,0,0):
			
			return q1
		
		else:
		
			return None
		
	else:
		
		return None

#----------------------------------------------------------------------------------------
def cross_point_2D(t1,t2,view):
	
	if view =='ZX':

		order=(0,2,1)

	elif	view =='YZ':

		order=(2,1,0)
	
	elif view =='XY':
		
		order=(0,1,2)

	p1=t1.vertices[0].position
	p2=t1.vertices[1].position
	p1=convert_world(p1)
	p2=convert_world(p2)
	
	p1=sort_order(p1,order)
	p1[2]=0
	p2=sort_order(p2,order)
	p2[2]=0
	
	v1=create_vector(p1,p2,True)
	
	p1=t2.vertices[0].position
	p2=t2.vertices[1].position
	p1=convert_world(p1)
	p2=convert_world(p2)
		
	p1=sort_order(p1,order)
	p1[2]=0
	p2=sort_order(p2,order)
	p2[2]=0
		
	v2=create_vector(p1,p2,True)
	
	p1=t1.vertices[0].position
	p2=t2.vertices[0].position
	p1=convert_world(p1)
	p2=convert_world(p2)
		
	p1=sort_order(p1,order)
	p1[2]=0
	p2=sort_order(p2,order)
	p2[2]=0
	
	v3=create_vector(p1,p2,False)
	
	#----------------------------------------------------------------------------------------
	p1=modo.Vector3(t1.vertices[0].position)
	p2=modo.Vector3(t2.vertices[0].position)
	p1=convert_world(p1)
	p2=convert_world(p2)
	#----------------------------------------------------------------------------------------

	w1=modo.mathutils.Vector3.dot(v1,v2)
	w2=1-(w1*w1)

	if w2<>0:
	
		d1=(modo.Vector3.dot(v3,v1) - w1 * modo.Vector3.dot(v3,v2)) / w2
		d2=(w1 * modo.Vector3.dot(v3,v1) - modo.Vector3.dot(v3,v2)) / w2
		
		v1.setLength(d1)
		v2.setLength(d2)
		
		v1=sort_order(v1,order)
		v2=sort_order(v2,order)
		
		q1=p1+v1
		q2=p2+v2
				
		return q1
			
	else:
		
		return None

#----------------------------------------------------------------------------------------
def sort_order(a,order):
	
	temp=[]

	for i in order:
	
		temp.append(a[i])

	return modo.mathutils.Vector3(temp)

#----------------------------------------------------------------------------------------	
def create_vert(cp):

	lx.eval('tool.set prim.makeVertex on 0')
	lx.eval('tool.reset')
	lx.eval('tool.setAttr prim.makeVertex cenX %s' %cp[0])
	lx.eval('tool.setAttr prim.makeVertex cenY %s' %cp[1])
	lx.eval('tool.setAttr prim.makeVertex cenZ %s' %cp[2])
	lx.eval('tool.apply')
	lx.eval('tool.set prim.makeVertex off 0')
	
	#vert=geo.vertices
	#vert.new(p)
	#geo.setMeshEdits()
	
#----------------------------------------------------------------------------------------		
def view_axis():

	view_id=lx.eval('query view3dservice view.index ? selected')
	view=lx.eval('query view3dservice view.angles ? %s' %view_id)
	
	if abs(math.degrees(view[1]))>=45:
		
		view='ZX'
	
	elif 135>abs(math.degrees(view[0]))>=45:
		
		view='YZ'
	
	else:
	
		view='XY'
		
	return view	

#----------------------------------------------------------------------------------------
def move_vertex(t1,cp):
		
	p1=t1.vertices[0].position
	p2=t1.vertices[1].position
	p1=convert_world(p1)
	p2=convert_world(p2)
		
	a=create_vector(p1,cp,False).length()
	b=create_vector(p2,cp,False).length()
	
	#----------------------------------------------------------------------------------------
	M4=mesh.channel('wrotMatrix').get()
	M4=modo.mathutils.Matrix4(M4)
	
	Q=modo.Quaternion()
	Q.fromMatrix4(M4)

	pos=mesh.position.get()
		
	p=modo.Vector3(cp)
	p-=pos	
	p.rotateByQuat(Q)
	

	#----------------------------------------------------------------------------------------
	
	lx.eval('select.type vertex')
		
	if a < b:
		
		vert=t1.vertices[0]
		lx.eval('select.element %s vertex set %s' %(mesh.index+1,vert.index))
		lx.eval('vert.set x %s' %p[0])
		lx.eval('vert.set y %s' %p[1])
		lx.eval('vert.set z %s' %p[2])
		#vert.position=cp
		#geo.setMeshEdits()
		
	else:
		
		vert=t1.vertices[1]
		lx.eval('select.element %s vertex set %s' %(mesh.index+1,vert.index))
		lx.eval('vert.set x %s' %p[0])
		lx.eval('vert.set y %s' %p[1])
		lx.eval('vert.set z %s' %p[2])
		#vert.position=cp
		#geo.setMeshEdits()
	
	lx.eval('select.type edge')
			
#----------------------------------------------------------------------------------------	
#-main-----------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------
mesh=lx.eval1('query layerservice layer.id ? fg')
mesh=modo.Mesh(mesh)
geo=mesh.geometry
edge=geo.edges.selected
#----------------------------------------------------------------------------------------	
if len(edge)>=2:
			
	t1=edge[0]
	t2=edge[len(edge)-1]
	
	args=lx.args()

	#----------------------------------------------------------------------------------------
	cp=cross_point_3D(t1,t2)	
	#----------------------------------------------------------------------------------------
	
	#----------------------------------------------------------------------------------------
	if type(cp) == modo.mathutils.Vector3:
		
		print cp
		
		if args[0]=='1': 
			
			move_vertex(t1,cp)
		
		else:
			
			create_vert(cp)
				
	else:
		
		axis=view_axis()
	
		#----------------------------------------------------------------------------------------
		cp=cross_point_2D(t1,t2,axis)
		#----------------------------------------------------------------------------------------
	
		if type(cp) == modo.mathutils.Vector3:
		
			if args[0]=='1': 
				
				move_vertex(t1,cp)
			
			else:
				
				create_vert(cp)

		#----------------------------------------------------------------------------------------	
	#----------------------------------------------------------------------------------------
	
else:
	
	modo.dialogs.alert('Intersect_Edge', 'Please select edges','error')

#----------------------------------------------------------------------------------------	
