#python
import lx

main=lx.eval1('query sceneservice selection ? mesh')
currentMesh=lx.eval('query layerservice layers ? %s' %main)

polys=lx.eval('query layerservice polys ? selected')

vert_list=[]
edge_set=[]
first_edge=[]
selection_set=[]

#-----------------------------------------------------------------------
if polys != None and len(polys)>=2:
	
	#-----------------------------------------------------------------------
	for i in polys:
	
		vert_list.append(lx.eval('query layerservice poly.vertList ? %s' %i))

	#-----------------------------------------------------------------------
	n=0
	
	for i in polys:
		
		if i!=polys[-1]:
			
			edge_set.append(list(set(vert_list[n]) & set(vert_list[n+1])))
	
		n=n+1
	
	#-----------------------------------------------------------------------
	first_edge=list(vert_list[0])

	for i in edge_set[0]:
			
		first_edge.remove(i)
		
	edge_set.insert(0,first_edge)	

	#-----------------------------------------------------------------------
	lx.eval('select.typeFrom edge')
	lx.eval('select.drop edge')

	for i in edge_set:
		
		if len(i)==2:

			lx.eval('select.element %s edge set %s %s' %(currentMesh,i[0],i[1]))
			s_name='temp'+str(i[0])+'_'+str(i[1])
			selection_set.append(s_name)
			
			lx.eval('select.editSet %s set' %s_name)
	
	lx.eval('select.typeFrom polygon')
	lx.eval('vert.split')
	#-----------------------------------------------------------------------
	#-----------------------------------------------------------------------
	
	lx.eval('select.type vertex')
	lx.eval('select.vertex add 3 0 temp_stair_weight')
	
 	selvert_num = lx.eval('query layerservice vert.N ? selected')
	
	if selvert_num==0:
		
		lx.eval('vertMap.new temp_stair_weight wght')	
		lx.eval('!select.vertexMap temp_stair_weight wght replace')	
	
	else:
		
		lx.eval('!select.vertexMap temp_stair_weight wght replace')	

	
	lx.eval('select.drop vertex')
	lx.eval('select.type polygon')
	
	lx.eval('tool.set falloff.vertexMap off')
	
	#-----------------------------------------------------------------------	
	#-----------------------------------------------------------------------

	n=1
	step_h=float(1)/(len(polys)+1)
	
	for i in polys:

		
		lx.eval('select.drop polygon')
		lx.eval('select.element %s polygon add %s' %(currentMesh, i))

		at_h=step_h*n
		
		lx.eval('tool.set vertMap.setWeight on')
		lx.eval('tool.reset')
		lx.eval('tool.attr vertMap.setWeight weight %s' %at_h)
		lx.eval('tool.apply')
		
		n+=1

	#-----------------------------------------------------------------------
	argvs=lx.args()
	
	if argvs[0]	=='1':
			
		lx.eval('select.typeFrom edge')
		lx.eval('select.drop edge')
		
		for i in selection_set:
			
			if i == selection_set[0]:
	
				lx.eval('select.useSet %s replace' %i)
				lx.eval('tool.set edge.extend on')
				lx.eval('tool.reset')
				lx.eval('tool.apply')
				lx.eval('tool.set edge.extend off')
				
			else:
	
				lx.eval('select.useSet %s replace' %i)
				lx.eval('tool.set edge.bridge on')
				
				flg=''
				
				if lx.eval('tool.flag flag:select ?')==True:
	
					lx.eval('tool.flag flag:select enable:false')
					flg='true'
	
				lx.eval('tool.reset')
				lx.eval('tool.attr edge.bridge segments 0')
				lx.eval('tool.attr edge.bridge connect false')
				lx.eval('tool.apply')
				
				if flg=='true':
	
					lx.eval('tool.flag flag:select enable:true')
				
				lx.eval('tool.set edge.bridge off')
			
	#-----------------------------------------------------------------------
	lx.eval('select.typeFrom polygon')
	
	for i in polys:

		lx.eval('select.element %s polygon add %s' %(currentMesh, i))	
		lx.eval('tool.set TransformMove on')
		lx.eval('tool.set falloff.vertexMap on')
		lx.eval("select.vertexMap temp_stair_weight wght replace")
			
	#-----------------------------------------------------------------------	
	#-----------------------------------------------------------------------
	for i in selection_set:
	
		lx.eval('vertMap.deleteByName EPCK "%s"' %i)
	#-----------------------------------------------------------------------
	#-----------------------------------------------------------------------

else:

	lx.eval('dialog.setup error')
	lx.eval('dialog.title stair_weight.py')
	lx.eval('dialog.msg "@mihi_tools@select2poly"')
	lx.eval('dialog.open')		

#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
