#python

import modo,math

#-----------------------------------------------------------
def toWorld(v):

	M4=mesh.channel('wrotMatrix').get()
	M4=modo.mathutils.Matrix4(M4)
	M4.invert()
	
	Q=modo.mathutils.Quaternion()
	Q.fromMatrix4(M4)
	
	p=modo.Vector3(v.position)
	p.rotateByQuat(Q)
	
	return p

#-----------------------------------------------------------
def toLocal(v):

	M4=mesh.channel('wrotMatrix').get()
	M4=modo.mathutils.Matrix4(M4)
	
	Q=modo.mathutils.Quaternion()
	Q.fromMatrix4(M4)

	v.rotateByQuat(Q)

	return v

#-----------------------------------------------------------
def view_axis():

	view_id=lx.eval('query view3dservice view.index ? selected')
	view=lx.eval('query view3dservice view.angles ? %s' %view_id)	
	
	x=math.degrees(view[0])
	y=math.degrees(view[1])
	z=math.degrees(view[2])
	
	#x----------------------------------------
	if -45 <= x <= 45:
	
		x=1
	
	elif 45<= x <= 135:
		
		x=2
		
	elif 135 <= x <=180:
		
		x=3
	
	elif -180 <= x <= -135:
	
		x=3
		
	elif -135 <= x <= -45: 
	
		x=4

	#y----------------------------------------	
	if -45 <= y <= 45:
	
		y=1
	
	elif 45<= y <= 135:
		
		y=2
		
	elif 135 <= y <=180:
		
		y=3
	
	elif -180 <= y <= -135:
	
		y=3
		
	elif -135 <= y <= -45:
	
		y=4
		
	#----------------------------------------
	if -45 <= z <= 45:
	
		z=1
	
	elif 45<= z <= 135:
		
		z=2
		
	elif 135 <= z <=180:
		
		z=3
	
	elif -180 <= z <= -135:
	
		z=3
		
	elif -135 <= z <= -45:
	
		z=4
	
	return x,y,z

#-----------------------------------------------------------
def set_LRTB(axis,flg):

#X-Right
	if axis==(1,1,1):
		
		left='x',min_x
		right='x',max_x
		bottom='y',min_y
		top='y',max_y
		
	elif axis==(1,2,1):
		
		left='x',min_x
		right='x',max_x
		bottom='z',max_z
		top='z',min_z
		
	elif axis==(1,4,1):
		
		left='x',min_x
		right='x',max_x
		bottom='z',max_z
		top='z',min_z
			
	elif axis==(3,1,3):
		
		left='x',min_x
		right='x',max_x
		bottom='y',max_y
		top='y',min_y	
		
	elif axis==(3,2,3):
		
		left='x',min_x
		right='x',max_x
		bottom='z',max_z
		top='z',min_z

	elif axis==(3,2,4):
		
		left='x',min_x
		right='x',max_x
		bottom='z',max_z
		top='z',min_z
				
	elif axis==(3,4,3):
		
		left='x',min_x
		right='x',max_x
		bottom='z',min_z
		top='z',max_z
		
	elif axis==(4,2,2):
	
		left='x',min_x
		right='x',max_x
		bottom='z',max_z
		top='z',min_z

	elif axis==(4,4,4):
	
		left='x',min_x
		right='x',max_x
		bottom='z',min_z
		top='z',max_z
			
	#Y-Right
	elif axis==(1,1,4):
		
		left='y',min_y
		right='y',max_y
		bottom='x',max_x
		top='x',min_x
	
	elif axis==(2,1,4):
		
		left='y',min_y
		right='y',max_y
		bottom='z',max_z
		top='z',min_z
			
	elif axis==(3,1,4):
		
		left='y',min_y
		right='y',max_y
		bottom='x',min_x
		top='x',max_x
		
	elif axis==(4,1,4):
		
		left='y',min_y
		right='y',max_y
		bottom='z',min_z
		top='z',max_z
						
	#Z-right
	elif axis==(2,1,1):
		
		left='z',min_z
		right='z',max_z
		bottom='y',min_y
		top='y',max_y
	
	elif axis==(4,2,3):
		
		left='z',min_z
		right='z',max_z
		bottom='x',min_x
		top='x',max_x
	
	elif axis==(4,1,3):
		
		left='z',min_z
		right='z',max_z
		bottom='y',max_y
		top='y',min_y
	
	elif axis==(1,4,4):
		
		left='z',min_z
		right='z',max_z
		bottom='x',max_x
		top='x',min_x
		
	elif axis==(2,4,1):
	
		left='z',min_z
		right='z',max_z
		bottom='x',max_x
		top='x',min_x
	
	elif axis==(2,2,1):
	
		left='z',min_z
		right='z',max_z
		bottom='x',min_x
		top='x',max_x

	elif axis==(1,2,2):
	
		left='z',min_z
		right='z',max_z
		bottom='x',min_x
		top='x',max_x
		
	elif axis==(4,4,3):
	
		left='z',min_z
		right='z',max_z
		bottom='x',max_x
		top='x',min_x		
						
	#X-Left
	elif axis==(1,1,3):
		
		left='x',max_x
		right='x',min_x
		bottom='y',max_y
		top='y',min_y		
	
	elif axis==(3,4,1):
		
		left='x',max_x
		right='x',min_x
		bottom='z',max_z
		top='z',min_z	
	
	elif axis==(3,1,1):
		
		left='x',max_x
		right='x',min_x
		bottom='y',min_y
		top='y',max_y			
	
	elif axis==(1,2,3):
		
		left='x',max_x
		right='x',min_x
		bottom='z',min_z
		top='z',max_z
		
	elif axis==(2,2,2):
		
		left='x',max_x
		right='x',min_x
		bottom='z',min_z
		top='z',max_z

	elif axis==(3,2,1):
		
		left='x',max_x
		right='x',min_x
		bottom='z',min_z
		top='z',max_z

	elif axis==(4,4,2):
		
		left='x',max_x
		right='x',min_x
		bottom='z',max_z
		top='z',min_z

	elif axis==(2,4,4):
		
		left='x',max_x
		right='x',min_x
		bottom='z',max_z
		top='z',min_z
		
	#Y-Left
	elif axis==(1,1,2):
		
		left='y',max_y
		right='y',min_y
		bottom='x',min_x
		top='x',max_x
		
	elif axis==(2,1,2):
		
		left='y',max_y
		right='y',min_y
		bottom='z',min_z
		top='z',max_z
		
	elif axis==(3,1,2):
		
		left='y',max_y
		right='y',min_y
		bottom='x',max_x
		top='x',min_x	
	
	elif axis==(4,1,2):
		
		left='y',max_y
		right='y',min_y
		bottom='z',max_z
		top='z',min_z
					
	#Z-Left
	elif axis==(4,4,1):
		
		left='z',max_z
		right='z',min_z
		bottom='x',min_x
		top='x',max_x		
				
	elif axis==(4,2,1):
		
		left='z',max_z
		right='z',min_z
		bottom='x',max_x
		top='x',min_x		
		
	elif axis==(4,1,1):
		
		left='z',max_z
		right='z',min_z
		bottom='y',min_y
		top='y',max_y	
			
	elif axis==(2,2,3):
		
		left='z',max_z
		right='z',min_z
		bottom='x',max_x
		top='x',min_x			
			
	elif axis==(2,1,3):
		
		left='z',max_z
		right='z',min_z
		bottom='y',max_y
		top='y',min_y
		
	elif axis==(3,2,2):
		
		left='z',max_z
		right='z',min_z
		bottom='x',max_x
		top='x',min_x

	elif axis==(2,4,3):
		
		left='z',max_z
		right='z',min_z
		bottom='x',min_x
		top='x',max_x
	
	elif axis==(3,4,4):
		
		left='z',max_z
		right='z',min_z
		bottom='x',min_x
		top='x',max_x
	
	#-----------------------------------------------------------
	
	if flg == '0':
		
		return left[0], left[1]
				
	elif flg == '1':
		
		return right[0], right[1]
		
	elif flg == '2':
		
		return top[0], top[1]
		
	elif flg == '3':
		
		return bottom[0], bottom[1]

	#-----------------------------------------------------------

#-----------------------------------------------------------
#-main------------------------------------------------------
#-----------------------------------------------------------
if lx.eval('select.typeFrom vertex;edge;polygon ?')==1:

	sel_type='vertex'

elif lx.eval('select.typeFrom edge;polygon;vertex ?')==1:
	
	sel_type='edge'

elif lx.eval('select.typeFrom polygon;edge;vertex ?')==1:
	
	sel_type='polygon'

lx.eval('select.convert vertex')

mesh = lx.eval1('query layerservice layer.id ? fg')
mesh = modo.Mesh(mesh)
geo=mesh.geometry
vertex=geo.vertices
vert=geo.vertices.selected
vertex.select()

if len(vert)>=2:

	vert_set=[]
	
	for i in vert:
	
		v=toWorld(i)
	
		vert_set.append(v)
		
	#-----------------------------------------------------------
	max_x=max(vert_set, key=lambda x:x[0])[0]
	max_y=max(vert_set, key=lambda x:x[1])[1]
	max_z=max(vert_set, key=lambda x:x[2])[2]
	min_x=min(vert_set, key=lambda x:x[0])[0]
	min_y=min(vert_set, key=lambda x:x[1])[1]
	min_z=min(vert_set, key=lambda x:x[2])[2]
	#-----------------------------------------------------------
	
	flg=lx.args()
	
	axis=view_axis()
	LRTB=set_LRTB(axis,flg[0])
	
	axes={'x':0, 'y':1, 'z':2}
	j=axes[LRTB[0]]
	
	for i in vert:
		
		v=toWorld(i)
		v[j]=LRTB[1]
		v=toLocal(v)
		
		i.position=(v[0],v[1],v[2])
		
		#vertex.select(i,1)
		
		#lx.eval('vert.set x %s' %v[0])
		#lx.eval('vert.set y %s' %v[1])
		#lx.eval('vert.set z %s' %v[2])

	geo.setMeshEdits()

	if sel_type=='vertex':
	
		vertex.select(vert,1)
		
	else:
	
		vertex.select()

lx.eval('select.typeFrom %s' %sel_type)





