#python
import lx,sys

currentMesh = lx.eval1('query sceneservice selection ? mesh')
main = lx.eval('query layerservice layer.index ? mash')
poly = lx.evalN('query layerservice polys ? selected')

try:
	
	if len(poly) == 0:
		sys.exit()
	
	#-------------------------------------------------------------
	lx.eval('lock.unsel')
	
	normals = []
	
	for i in poly:
		lx.eval('select.element %s polygon set %s' % (main,i))
		normal = lx.evalN('query layerservice poly.normal ? %s' % i)
		normals.append(normal)
		
	#-------------------------------------------------------------
	lx.eval('select.all')
	lx.eval('copy')
	lx.eval('layer.new')
	tempMesh = lx.eval('query sceneservice selection ? mesh')
	lx.eval('paste')
	#-------------------------------------------------------------
	lx.eval('select.item %s set' %currentMesh)
	lx.eval('select.typeFrom polygon')
	lx.eval('select.all')
	
	#-------------------------------------------------------------
	
	if normals[-1][0] == 1 or normals[-1][0] == -1:
		lx.eval('poly.drill slice x Default specific %s' %tempMesh)
	elif normals[-1][1] == 1 or normals[-1][1] == -1:
		lx.eval('poly.drill slice y Default specific %s' %tempMesh)
	elif normals[-1][2] == 1 or normals[-1][2] == -1:
		lx.eval('poly.drill slice z Default specific %s' %tempMesh)
	
	#-------------------------------------------------------------
	lx.eval('!vert.merge auto')
	lx.eval('select.typeFrom polygon')
	lx.eval('select.all')
	lx.eval('!poly.unify false')
	lx.eval('select.all')
	#lx.eval('!poly.merge')
	lx.eval('!mesh.cleanup true true true true true true true true true true')
	
	#-------------------------------------------------------------
	lx.eval('select.item %s set' %tempMesh)
	lx.eval('delete')
	lx.eval('select.item %s set' %currentMesh)
	lx.eval('select.typeFrom polygon')
	#-------------------------------------------------------------
	
	lx.eval('select.all')
	lx.eval('unlock')
	
except SystemExit:
    dummy=0

