#python
import lx
import math
##-------------------------------------------------------------
##-------------------------------------------------------------
def CrossProduct(ver0,ver1):
	
	return ver0[0]*ver1[1] - ver0[1]*ver1[0]
##-------------------------------------------------------------
##-------------------------------------------------------------

def CheckIntersection(currentVer,piA,piC):
	
	#Line1---------
	pA = piA
	pC = piC
	#--------------
	
	n=0
	
	currentVer=int(currentVer)

	Intersect_X=[]
	Intersect_Y=[]
	Distance = []
	
	CrossProduct1=0
	CrossProduct2=0
	
	for i in edge:
		
		##-------------------------------------------------------------
		if i[0] == currentVer or i[1]==currentVer:			
			
			continue
			
		else:	
			
			##-------------------------------------------------------------
			pB = lx.eval('query layerservice vert.Pos ? %s' %i[0])
			pD = lx.eval('query layerservice vert.Pos ? %s' %i[1])
			
			BD=[(pD[0]-pB[0]),(pD[2]-pB[2])]
			BA=[(pA[0]-pB[0]),(pA[2]-pB[2])]
			BC=[(pC[0]-pB[0]),(pC[2]-pB[2])]
			
			CrossProduct1=CrossProduct(BD,BA)*CrossProduct(BD,BC)
			
			if CrossProduct1>0:
		
				continue
			
			AC=[(pC[0]-pA[0]),(pC[2]-pA[2])]
			AB=[(pB[0]-pA[0]),(pB[2]-pA[2])]
			AD=[(pD[0]-pA[0]),(pD[2]-pA[2])]
			
			CrossProduct2=CrossProduct(AC,AB)*CrossProduct(AC,AD)
			
			if CrossProduct2>=0:
		
				continue
			
			else:
				
				n=n+1	
			
				BDAB=CrossProduct(BD,AB)
				BDBC=CrossProduct(BD,BC)
			
				total = BDAB+BDBC
			
				K=BDAB/total			
											
				Intersect_X.append(pA[0]+K*AC[0])
				Intersect_Y.append(pA[2]+K*AC[1])
				
			##-------------------------------------------------------------
		##-------------------------------------------------------------
	##-------------------------------------------------------------

	if n % 2==1:	
		
		##-------------------------------------------------------------
		for m in range(0,n):
			
			Distance.append(math.sqrt(pow((Intersect_X[m]-pA[0]),2)+pow((Intersect_Y[m]-pA[2]),2)))

			id=Distance.index(min(Distance))
				
		##-------------------------------------------------------------	
		return (True , Intersect_X[id] , Intersect_Y[id])
		
	else:
	
		return False

##-------------------------------------------------------------
##--main-------------------------------------------------------
##-------------------------------------------------------------

main = lx.eval1('query sceneservice selection ? mesh')
currentMesh = lx.eval('query layerservice layers ? %s' %main)

vert = lx.evalN('query layerservice verts ? selected')

lx.eval('item.refSystem %s' %main)

##-------------------------------------------------------------
##-------------------------------------------------------------
if vert != () and lx.eval('view3d.projection ?')=='top':
	
	#-エッジ取得-----------------------------------------------------------------
	poly = lx.evalN('query layerservice vert.polyList ? %s' %vert[0])
	
	vert_list = lx.evalN('query layerservice poly.vertList ? %s' %poly[0])
	
	all_vert=len(vert_list)
	edge=[]
	polys=[]
		
	for i in range(0,all_vert):
		
		edge.append([vert_list[i],vert_list[i-1]])		
	#---------------------------------------------------------------------------
	
	#-隣接頂点を結ぶ直線に垂直な点Pを求める-------------------------------------------
	for v in vert:
		
		adj_vert=lx.eval('query layerservice vert.vertList ? %s' %v)
		
		#------------------------------------------------------------
		if len(adj_vert)<3:
				
			v1=lx.eval('query layerservice vert.pos ? %s' %adj_vert[0])
			v2=lx.eval('query layerservice vert.pos ? %s' %adj_vert[1])
			
			x1=v1[0]
			x2=v2[0]
			y1=v1[2]
			y2=v2[2]
			
			x=x2-x1
			y=y2-y1
		
			if x==0:
							
				slope = math.radians(90)
			
			elif y==0:
				
				slope = 0												
			else:
				
				slope = math.atan(y/x)
		
			st_Pos=[]
			st_Pos.append(lx.evalN('query layerservice vert.pos ? %s' %v)[0])			
			st_Pos.append(0)		
			st_Pos.append(lx.evalN('query layerservice vert.pos ? %s' %v)[2])
			
			tg_Pos=[]
			tg_Pos.append(math.cos(slope+math.radians(90))*1000+st_Pos[0])
			tg_Pos.append(0)
			tg_Pos.append(math.sin(slope+math.radians(90))*1000+st_Pos[2])
			
			#-交点検索-------------------------------------------------------------
			
			Intersection = CheckIntersection(v,st_Pos,tg_Pos)
			
			if Intersection==False:
				
				tg_Pos=[]
				tg_Pos.append(math.cos(slope-math.radians(90))*1000+st_Pos[0])
				tg_Pos.append(0)
				tg_Pos.append(math.sin(slope-math.radians(90))*1000+st_Pos[2])

				Intersection = CheckIntersection(v,st_Pos,tg_Pos)
				
			if Intersection==False:
				
				continue
				
			lx.eval('tool.set poly.knife on')
			
			flg=lx.eval('tool.attr poly.knife infinite  ?')
			
			lx.eval('tool.reset')
			lx.eval('tool.setAttr poly.knife startX %s' %st_Pos[0])
			lx.eval('tool.setAttr poly.knife startY 0')
			lx.eval('tool.setAttr poly.knife startZ %s' %st_Pos[2])
			lx.eval('tool.setAttr poly.knife endX %s' %Intersection[1])
			lx.eval('tool.setAttr poly.knife endY 0')
			lx.eval('tool.setAttr poly.knife endZ %s' %Intersection[2])
			
			lx.eval('tool.doApply')
			
			if flg==True:lx.eval('tool.setAttr poly.knife infinite true')
			
			lx.eval('tool.set poly.knife off')
	
			#------------------------------------------------------------
		for n in lx.evalN('query layerservice vert.polyList ? %s' %v):
				
			polys.append(n)
			
	polys = list(set(polys))	

	if len(polys) != 0:
		
		lx.eval('select.drop vertex')
		lx.eval('select.drop polygon')
		
		for i in polys:
			
			lx.eval('select.element %s polygon add %s' %(currentMesh,i))
	
		lx.eval('lock.unsel')
		lx.eval('select.vertex add edge equal 2')
		lx.eval('unlock')	
		#---------------------------------------------------------------	
	#-----------------------------------------------------------------
else:
	
	if len(vert)==0:
	
		lx.eval('dialog.setup error')
		lx.eval('dialog.title Slice_Avr_Agl.py')
		lx.eval('dialog.msg "@mihi_tools@selectvertx"')
		lx.eval('dialog.open')	

	else:

		lx.eval('dialog.setup error')
		lx.eval('dialog.title Slice_Avr_Agl.py')
		lx.eval('dialog.msg "@mihi_tools@selecttopview"')
		lx.eval('dialog.open')	

##---------------------------------------------------------------------
##---------------------------------------------------------------------
lx.eval('item.refSystem {}')	
##---------------------------------------------------------------------
##---------------------------------------------------------------------


