#python
import lx
#----------------------------------------------------------------------	
#----------------------------------------------------------------------	
def calculate_normal(P):
	
	p1=P[0]
	p2=P[1]
	p3=P[2]	

	Sx=p2[0]-p1[0]
	Sy=p2[1]-p1[1]
	Sz=p2[2]-p1[2]
	
	Tx=p3[0]-p1[0]
	Ty=p3[1]-p1[1]
	Tz=p3[2]-p1[2]
	
	STx=Sy*Tz-Sz*Ty
	STy=Sz*Tx-Sx*Tz
	STz=Sx*Ty-Sy*Tx
	
	volume=pow(STx*STx+STy*STy+STz*STz,0.5)
		
	a=STx/volume
	b=STy/volume
	c=STz/volume
	
	normal=(a,b,c)
	
	return normal
#----------------------------------------------------------------------	
#----------------------------------------------------------------------	
def calculate_pos(edge_id,V):
	
	id=str(edge_id[0]) + ',' + str(edge_id[1])
	
	length=lx.eval('query layerservice edge.length ? %s' %(id))
	vector=lx.eval('query layerservice edge.vector ? %s' %(id))
	
	a=V[0]
	b=V[1]
	c=V[2]
	d=(a*P4[0]+b*P4[1]+c*P4[2])*-1
	
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[0])
	x1=pos[0]
	y1=pos[1]
	z1=pos[2]
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[1])
	x2=pos[0]
	y2=pos[1]
	z2=pos[2]
	
	vx=x2-x1
	vy=y2-y1
	vz=z2-z1
	
	ex=vx/length
	ey=vy/length
	ez=vz/length
	
	try:
		k=(a*x1+b*y1+c*z1+d)*-1/(a*ex+b*ey+c*ez)
	
		tx=x1+k*ex
		ty=y1+k*ey
		tz=z1+k*ez
	
		return tx,ty,tz

	except:
		
		return False
  
#----------------------------------------------------------------------
#----------------------------------------------------------------------

#----------------------------------------------------------------------	
#-main-----------------------------------------------------------------	
#----------------------------------------------------------------------
main=lx.eval1('query sceneservice selection ? mesh')
currentMesh=lx.eval('query layerservice layers ? main')
verts=lx.evalN('query layerservice verts ? selected')	
#----------------------------------------------------------------------
if len(verts)==4:

	lx.eval('item.refSystem %s' %main)
	P=[]
	#----------------------------------------------------------------------	
	for i in verts:
		P.append(lx.eval('query layerservice vert.pos ? %s' %i))
	#----------------------------------------------------------------------	
	normal=calculate_normal(P)
	#-1--------------------------------------------------------------------
	P1=[x+y for (x,y) in zip(P[1],normal)]
	Pset=(P[0],P[1],P1)
	N1=calculate_normal(Pset)
	#-2-collision Plain----------------------------------------------------
	P2=[x+y for (x,y) in zip(P[1],N1)]
	P4=[x+y for (x,y) in zip(P[1],normal)]
	Pset=(P[1],P2,P4)
	N2=calculate_normal(Pset)
	#----------------------------------------------------------------------
	#----------------------------------------------------------------------
	tg_edge=(verts[2],verts[3])
	tg_pos=calculate_pos(tg_edge,N2)
	
	lx.eval('vertMap.setVertex position position 0 %s %s' %(verts[2],tg_pos[0]))
	lx.eval('vertMap.setVertex position position 1 %s %s' %(verts[2],tg_pos[1]))
	lx.eval('vertMap.setVertex position position 2 %s %s' %(verts[2],tg_pos[2]))
	
	lx.eval('item.refSystem {}')	
#----------------------------------------------------------------------
else:
	lx.eval('dialog.setup error')
	lx.eval('dialog.title Right_Angle_Vert.py')
	lx.eval('dialog.msg "@mihi_tools@select4vertx"')
	lx.eval('dialog.open')	
#----------------------------------------------------------------------
#----------------------------------------------------------------------