#python
import lx,math

def view_axis():

	view_id=lx.eval('query view3dservice view.index ? selected')
	view=lx.eval('query view3dservice view.angles ? %s' %view_id)
	
	if abs(math.degrees(view[1]))>=45:
		
		view='ZX'
	
	elif 135>abs(math.degrees(view[0]))>=45:
		
		view='YZ'
	
	else:
	
		view='XY'
		
	return view	
	
#----------------------------------------------------------
def calculate_vector(p1,p2):
	
	x=p2[0]-p1[0]
	y=p2[1]-p1[1]
	z=p2[2]-p1[2]
	
	l=pow(x*x+y*y+z*z,0.5)
	
	x=x/l
	y=y/l
	z=z/l
	
	return x,y,z

def calculate_vector_2D(p1,p2):
	
	try:
	
		x=p2[0]-p1[0]
		y=p2[1]-p1[1]
		
		l=pow(x*x+y*y,0.5)
		
		x=x/l
		y=y/l
	
		return x,y
	
	except:
		
		return None

#----------------------------------------------------------	
def calculate_tri(P):

	p1=P[0]
	p2=P[1]
	p3=P[2]	

	Sx=(p2[0]-p1[0])
	Sy=(p2[1]-p1[1])
	Sz=(p2[2]-p1[2])
	
	Tx=(p3[0]-p1[0])
	Ty=(p3[1]-p1[1])
	Tz=(p3[2]-p1[2])
	
	STx=(Sy*Tz-Sz*Ty)
	STy=(Sz*Tx-Sx*Tz)
	STz=(Sx*Ty-Sy*Tx)
	
	volume=pow(STx*STx+STy*STy+STz*STz,0.5)
	
	try:
		
		a=STx/volume
		b=STy/volume
		c=STz/volume
	
		normal=(a,b,c)
	
	except:
		
		return False
	
	normal=map(round,normal,[6]*len(normal))
	
	return normal
	
#----------------------------------------------------------
def calculate_pos(edge_id,V,p):
	
	id=str(edge_id[0]) + ',' + str(edge_id[1])
	
	length=lx.eval('query layerservice edge.length ? %s' %(id))
	vector=lx.eval('query layerservice edge.vector ? %s' %(id))
	
	a=V[0]
	b=V[1]
	c=V[2]
	d=(a*p[0]+b*p[1]+c*p[2])*-1
	
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[0])
	x1=pos[0]
	y1=pos[1]
	z1=pos[2]
	pos=lx.eval('query layerservice vert.pos ? %s' %edge_id[1])
	x2=pos[0]
	y2=pos[1]
	z2=pos[2]
	
	vx=x2-x1
	vy=y2-y1
	vz=z2-z1
	
	ex=vx/length
	ey=vy/length
	ez=vz/length
	
	try:
		k=(a*x1+b*y1+c*z1+d)*-1/(a*ex+b*ey+c*ez)
	
		tx=x1+k*ex
		ty=y1+k*ey
		tz=z1+k*ez 
	
		return tx,ty,tz

	except:
		
		return False
		
#----------------------------------------------------------
def calculate_2Dpos(p1,p2,p3,p4):
	
	#----------------------------------------------------------
	view = view_axis()
	#----------------------------------------------------------
	if view =='ZX':

		axis_x=0
		axis_y=2

	elif	view =='YZ':

		axis_x=2
		axis_y=1
	
	elif view =='XY':
		
		axis_x=0
		axis_y=1					
	#----------------------------------------------------------					
	
	P1 = (p1[axis_x], p1[axis_y])
	P2 = (p2[axis_x], p2[axis_y])
	P3 = (p3[axis_x], p3[axis_y])
	P4 = (p4[axis_x], p4[axis_y])
	
	v1=calculate_vector_2D(P1,P2)
	v2=calculate_vector_2D(P3,P4)
	
	try:
		
		n=v1[1]*v2[0]-v1[0]*v2[1]
	
	except:
		
		return None
	
	s=(P4[1]-P3[1])*(P4[0]-P1[0])-(P4[0]-P3[0])*(P4[1]-P1[1])
	d=(P2[0]-P1[0])*(P4[1]-P3[1])-(P2[1]-P1[1])*(P4[0]-P3[0])
	
	try:
		
		r=s/d

	except:
		
		return None

	x=P1[0]+r*(P2[0]-P1[0])
	y=P1[1]+r*(P2[1]-P1[1])
	
	if view =='ZX':

		x=x
		z=y
		y=p1[1]

		
	elif	view =='YZ':

		z=x
		y=y
		x=p1[0]
	
	elif view =='XY':
		
		x=x
		y=y
		z=p1[2]	

	return x,y,z

#----------------------------------------------------------
def distance(p1,p2):

	x=p2[0]-p1[0]
	y=p2[1]-p1[1]
	z=p2[2]-p1[2]

	return pow(x*x+y*y+z*z,0.5)
#----------------------------------------------------------	.
def mid(p1,p2):

	x=(p2[0]+p1[0])/2
	y=(p2[1]+p1[1])/2
	z=(p2[2]+p1[2])/2

	return x,y,z
#----------------------------------------------------------	.
def move_point():
	
	length=[]
	
	#----------------------------------------------------------	.
	for i in verts:
			
		length.append(i)
		length.append(distance(Intersection,lx.eval('query layerservice vert.pos ? %s' %i)))
	
	#----------------------------------------------------------	.	
	if length[1]<length[3]:
		tv1=length[0]
	else:
		tv1=length[2]
		
	if length[5]<length[7]:
		tv2=length[4]
	else:
		tv2=length[6]
	#----------------------------------------------------------	.
		
	lx.eval('vertMap.setVertex position position 0 %s %s' %(tv1,Intersection[0]))
	lx.eval('vertMap.setVertex position position 1 %s %s' %(tv1,Intersection[1]))
	lx.eval('vertMap.setVertex position position 2 %s %s' %(tv1,Intersection[2]))
	lx.eval('vertMap.setVertex position position 0 %s %s' %(tv2,Intersection[0]))
	lx.eval('vertMap.setVertex position position 1 %s %s' %(tv2,Intersection[1]))
	lx.eval('vertMap.setVertex position position 2 %s %s' %(tv2,Intersection[2]))	

def create_vertex():
	
	lx.eval('tool.set prim.makeVertex on 0')
	lx.eval('tool.reset')
	lx.eval('tool.setAttr prim.makeVertex cenX %s' %Intersection[0])
	lx.eval('tool.setAttr prim.makeVertex cenY %s' %Intersection[1])
	lx.eval('tool.setAttr prim.makeVertex cenZ %s' %Intersection[2])
	lx.eval('tool.apply')
	lx.eval('tool.set prim.makeVertex off 0')
  
def dotproduct(p1,p2):
	
	return p1[0]*p2[0]+p1[1]*p2[1]+p1[2]*p2[2]	
			
#----------------------------------------------------------
#----------------------------------------------------------
#-main	
#----------------------------------------------------------
#----------------------------------------------------------
main=lx.eval1('query sceneservice selection ? mesh')
currentLayer=('query layerservice layers ? %s' %main)
edge=lx.evalN('query layerservice edges ? selected')

lx.eval('item.refSystem %s'%main)
#----------------------------------------------------------
verts=[]  
tri1=[]
tri2=[]

#----------------------------------------------------------
if len(edge)!=0:

	for i in edge:
		
		i=i.strip('()').split(',')
		
		for n in i:
			
			verts.append(n)
		
	p1=lx.eval('query layerservice vert.pos ? %s' %verts[0])
	p2=lx.eval('query layerservice vert.pos ? %s' %verts[1])
	p3=lx.eval('query layerservice vert.pos ? %s' %verts[2])
	p4=lx.eval('query layerservice vert.pos ? %s' %verts[3])
	#----------------------------------------------------------
	
	ab=calculate_vector(p1,p2)
	cd=calculate_vector(p3,p4)
	
	#-誤差補正---------------------------------------------------
	w=round(1-dotproduct(ab,cd),5)
	if w==2:w=0
	
	#----------------------------------------------------------
	
	if w!=0:
		
		tri1=(p1,p2,p3)
		tri2=(p3,p4,p1)
		tri1=calculate_tri(tri1)
		tri2=calculate_tri(tri2)
	
		
		plain1=[]
		plain2=[]
		
		plain1=map(abs,tri1)
		plain1=map(round,plain1,[5]*len(plain1))
		plain2=map(abs,tri2)
		plain2=map(round,plain2,[5]*len(plain2))			


		p5=[x+y for (x,y) in zip(p1,tri1)]
		p6=[x+y for (x,y) in zip(p3,tri2)]
		 
		tri1=(p1,p2,p5)
		tri2=(p3,p4,p6)
		
		tri1=calculate_tri(tri1)
		tri2=calculate_tri(tri2)
		
		edge1=(verts[0],verts[1])
		edge2=(verts[2],verts[3])			

		#----------------------------------------------------------		
		if plain1==plain2:
			
			Intersection=calculate_pos(edge1,tri2,p6)		
		
		else:
							
			Intersection=calculate_2Dpos(p1,p2,p3,p4)

		if Intersection==None:
				
				lx.eval('dialog.setup error')
				lx.eval('dialog.title Intersect_Edge_3d.py')
				lx.eval('dialog.msg "@mihi_tools@no_cross2"')
				lx.eval('dialog.open')	
		
		else:	
		
			argvs=lx.args()
			
			if argvs[0]=='1':
		
				move_point()

			else:
				
				create_vertex()
				
	else:
			
		lx.eval('dialog.setup error')
		lx.eval('dialog.title Intersect_Edge_3d.py')
		lx.eval('dialog.msg "@mihi_tools@no_cross"')
		lx.eval('dialog.open')	

#----------------------------------------------------------
else:
	
	lx.eval('dialog.setup error')
	lx.eval('dialog.title Intersect_Edge_3d.py')
	lx.eval('dialog.msg "@mihi_tools@select2edge"')
	lx.eval('dialog.open')	
		
lx.eval('item.refSystem {}')