#python/Users/harue/Dropbox/modo_pyscript/mjg_cutoff_wgt/scripts/mjg_cutoff_wgt.py

# Make Locators Per Each Points
# Author MODO JAPAN GROUP
# version 1.0


import lx

#################################################################
#	Main function
#################################################################

# Get ID of mesh layer
fg = lx.eval1( 'query layerservice layers ? fg' )
fg_index = lx.eval( 'query layerservice layer.index ? fg' )
fg_id = lx.eval( 'query layerservice layer.id ? fg' )

new_locators = []

# If EditMode is vertex
if lx.eval( 'select.typeFrom vertex;edge;polygon;item;pivot;center;ptag ?' ):

	vert_selnum = lx.eval( 'query layerservice vert.N ? selected' )
	verts = lx.evalN( 'query layerservice verts ? selected' )

	if verts:

		# Create Progress bar
		m = lx.Monitor()

		# Initialize Progress bar
		m.init( vert_selnum )

		for vertID in verts :

			# Step Monitor
			m.step( 1 )

			# Get Point Index Number
			vid = lx.eval( 'query layerservice vert.index ? %s' % vertID )

			# Make a locator
			lx.eval('item.create locator')

			# Get ID for new locator
			new_id = lx.eval('query sceneservice selection ? locator' )
			lx.out( new_id )
			new_locators.append( new_id )

			# Select Item
			lx.eval('select.subItem %s add mesh' % fg_id)

			# Apply constraint
			lx.eval('constraintGeometry vert pos')

			# Set Vertex Index number
			lx.eval('item.channel cmGeometryConstraint$indexA %s' % vertID)

# Select all locators
lx.eval('select.subItem %s set mesh' % new_locators[ 0 ])

for i in range ( 1, vert_selnum ):

	lx.eval('select.subItem %s add mesh' % new_locators[ i ])

# Baking Animations
lx.eval('item.bake 0')

# Group
lx.eval('layer.groupSelected')
