#python

# Get Data From CSV File
# Author MODO JAPAN GROUP
# version 1.1

import lx

############################################################################
### Sub routine for File Dialog
############################################################################
def customfile(type, title, format, uname, ext, save_ext=None, path=None):
    ''' Custom file dialog wrapper function

        type  :   Type of dialog, string value, options are 'fileOpen' or 'fileSave'
        title :   Dialog title, string value.
        format:   file format, tuple of string values
        uname :   internal name
        ext   :   tuple of file extension filter strings
        save_ext: output file extension for fileSave dialog
        path  :   optional default loacation to open dialog

    '''
    lx.eval("dialog.setup %s" % type)
    lx.eval("dialog.title {%s}" % (title))
    lx.eval("dialog.fileTypeCustom {%s} {%s} {%s} {%s}" % (format, uname, ext, save_ext))
    if type == 'fileSave' and save_ext != None:
        lx.eval("dialog.fileSaveFormat %s extension" % save_ext)
    if path != None:
        lx.eval('dialog.result {%s}' % path)
    try:
        lx.eval("dialog.open")
        return lx.eval("dialog.result ?")
    except:
        return None


############################################################################
### Main
############################################################################

# Get CSV File
csv_filename = customfile( 'fileOpen', 'Open CSV file', 'CSV','Vertex Position File', '*.csv','','' )

if ( csv_filename ) :

	# Open CSV File
	csv_file = open( csv_filename )

	# Count Line Number
	lines = csv_file.readlines()
	line_num = len( lines )

	# Close CSV File
	csv_file.close()

	# Re-Open CSV File
	csv_file = open( csv_filename )

	# Activate Point Tool
	lx.eval( 'tool.set prim.makeVertex on 0' )
	lx.eval( 'tool.attr prim.makeVertex polygon true' )

	# Create Progress bar
	m = lx.Monitor()

	# Initialize Progress bar
	m.init( line_num )

	# Read each line
	for line in csv_file :

		# Get point position from line
		px, py, pz = line.split( ',' )

		# Step Monitor
		m.step( 1 )

		# Set Point Position and apply
		lx.eval( 'tool.attr prim.makeVertex cenX %s' % px )
		lx.eval( 'tool.attr prim.makeVertex cenY %s' % py )
		lx.eval( 'tool.attr prim.makeVertex cenZ %s' % pz )
		lx.eval( 'tool.apply' )

	# Drop Point Tool
	lx.eval( 'tool.set prim.makeVertex off 0' )

	# Close CSV File
	csv_file.close()
