#python

# Fix Instanced Light Material
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

# get item number in current scene
item_num = lx.eval( "query sceneservice item.N ?" )

lgt_num = 0
lgt_ids = []

for i in range( 0, item_num):

	com_string = "query sceneservice item.type ? " + str( i )
	item_type = lx.eval( com_string )

	com_string = "query sceneservice item.id ? " + str( i )
	item_id = lx.eval( com_string )

	com_string = "query sceneservice item.isSelected ? " + str( i )
	item_selected = lx.eval( com_string )

	com_string = "query sceneservice item.source ? " + str( i )
	item_inst = lx.eval( com_string )

	# Find Light
	if ( ( item_type == 'sunLight' ) or
	( item_type == 'pointLight' )  or
	( item_type == 'spotLight' )  or
	( item_type == 'areaLight' )  or
	( item_type == 'cylinderLight' ) or
	( item_type == 'domeLight' ) or
	( item_type == 'portal' ) or
	( item_type == 'photometryLight' ) ) :

		lgt_ids.append( item_id )

		# Selected and Source Light
		if ( ( item_selected ) and not ( item_inst ) ) :

			src_light = item_id

			com_string = "query sceneservice item.children ? " + src_light
			item_children = lx.evalN( com_string )

			for item_child in item_children :

				com_string = "query sceneservice item.type ? " + item_child
				item_type = lx.eval( com_string )

				if( item_type == 'lightMaterial' ) :
					src_lgtmaterial = item_child


# Find Instanced Light
for lgt_id in lgt_ids :

	com_string = "query sceneservice item.source ? " + str( lgt_id )
	item_source = lx.eval( com_string )

	if( item_source == src_light ):

		# Delete wrong light material
		com_string = "query sceneservice item.children ? " + lgt_id
		item_children = lx.evalN( com_string )

		for item_child in item_children :

			com_string = "query sceneservice item.type ? " + item_child
			item_type = lx.eval( com_string )

			if( item_type == 'lightMaterial' ) :

				com_string = "select.subItem " + item_child + " set textureLayer;render;environment;light;camera;scene;replicator;mediaClip;txtrLocator"
				lx.eval( com_string )

				lx.eval( "texture.delete" )

		# Select Source Light Material
		com_string = "select.subItem " + src_lgtmaterial + " set textureLayer;render;environment;light;camera;scene;replicator;mediaClip;txtrLocator"
		lx.eval( com_string )

		# Create Instance
		lx.eval( "texture.instance" )

		# Move Instanced Light
		com_string = "texture.parent " + lgt_id + " -1"
		lx.eval( com_string )

