#python

# Delete Extra Polygon Set
# Author MODO JAPAN GROUP
# version 1.2


import sys
import lx


#################################################################
# Function to get index of Material Group
#		return -1 if 'idname' is not in 'mgroup_lists'
#################################################################
def GetMaterialGroupIndex( mgroup_lists, name ):

	index = 0
	for str_name in mgroup_lists:
		if ( str_name == name ) :
			return index
		index += 1

	return -1


#################################################################
#	Main function
#################################################################

# Select All
lx.eval( 'select.all' )

# Get Polygon Selection Set Information
plset_num = lx.eval( 'query layerservice polset.N ? all' )

if ( plset_num > 0 ) :

	plset_lists = lx.evalN( 'query layerservice polsets ? all' )
	plset_names = []

#	lx.out('polygon selection set number = %d' % plset_num )

	for plist in plset_lists:

		# Get Polygon Selection
		plist_name = lx.eval( 'query layerservice polset.name ? %s' % plist )
		plset_names.append( plist_name )

		plist_id = lx.eval( 'query layerservice polset.index ? %s' % plist )
#		lx.out( 'plist_name = %s, id = %s' % ( plist_name, plist_id ) )


# Get Material Group Information
mask_num = lx.eval('query sceneservice mask.N ? all')
mask_ids = []
mask_names = []
mask_ptags = []

for i in range( mask_num ):

	mask_name = lx.eval("query sceneservice mask.name ? %d" % i )
	mask_id = lx.eval("query sceneservice mask.id ? %d" % i )

	# Select Material Group
	lx.eval('select.subItem %s set textureLayer 0 0' % mask_id)

	ptagtype = lx.eval("mask.setPTagType ?")

	# If Material Group Type is Selection Set
	if ( ptagtype == 'Selection Set' ):

		# Get Polygon Tag Name
		ptagname = lx.eval("mask.setPTag ?")
#		lx.out('ptagname = %s' % ptagname )

		mask_ptags.append( ptagname )
		mask_names.append( mask_name )
		mask_ids.append( mask_id )


changenum = 0
change_mgroup = []
change_mesh = []

# Check Mesh Layer
lyrnum = lx.eval( 'query layerservice layer.N ? all' )
lyrlist = lx.evalN( 'query layerservice layers ? all' )

# Scan each Layer
if ( lyrnum > 0 ):

	for lyr in lyrlist:

		# Select each layer
		layer_id = lx.eval( 'query layerservice layer.id ? %s' % lyr )
		comstring = 'select.subItem ' + layer_id + ' set mesh 0 0'
		lx.eval( comstring )

		layer_name = lx.eval( 'query layerservice layer.name ? %s' % lyr )
#		lx.out( 'layer name = %s, id = %s' % (layer_name, layer_id) )

		# Get Polygon Num
		allpolnum = lx.eval( 'query layerservice poly.N ? all' )
#		lx.out( 'allpolnum = %d'% allpolnum )

		# Check Polygon Selection
		for i in range( plset_num ):

			lx.eval( 'select.typeFrom polygon;edge;vertex;item;pivot;center;ptag true' )

			lx.eval( 'select.useSet "%s" select' % plset_names[ i ] )
			polnum = lx.eval( 'query layerservice poly.N ? selected' )
#			lx.out( 'plset_names[ i ] = %s, polnum = %d, allpolnum = %d' % (plset_names[ i ], polnum, allpolnum ) )

			if ( ( polnum > 0 ) and ( polnum == allpolnum ) ):

				# Get Material Index
				mgindex = GetMaterialGroupIndex( mask_ptags, plset_names[ i ] )

				if( mgindex != -1 ):

					changenum += 1
					change_mgroup.append( mgindex )
					change_mesh.append( layer_name )

					lx.eval( 'select.editSet "%s" remove {}' % plset_names[ i ] )

			lx.eval( 'select.drop polygon' )


# Change Material Group
for i in range( changenum ):

	mgindex = change_mgroup[ i ]

	lx.eval('select.subItem %s set textureLayer;render;environment;light;camera;scene;replicator;mediaClip;txtrLocator' % mask_ids[ mgindex ] )

	lx.eval( 'mask.setMesh "%s"' % change_mesh[ i ] )
	lx.eval( 'mask.setPTagType Material' )
	lx.eval( 'mask.setPTag (S)' )

	lx.eval('select.subItem %s unset textureLayer;render;environment;light;camera;scene;replicator;mediaClip;txtrLocator' % mask_ids[ mgindex ] )

