#python

# Cutoff Tiny Weight Value
# Author MODO JAPAN GROUP
# version 1.0


import lx

#################################################################
#	Main function
#################################################################

# Get arguments: 'Clear' or 'Select'
argsAsString = lx.arg()

# Set argument to 'Select' if arg string is empty
if ( argsAsString == '' ) :
	argsAsString = 'Select'

# Get Parameter
cutoff_val = lx.eval( 'user.value mjg_cutoffwgt ?' )
#cutoff_val = 0.1
#lx.out( 'cutoff_val = %s' % cutoff_val )

# Get Weight Information
weight_lists = lx.eval( 'query layerservice vmaps ? weight' )
weight_num = lx.eval( 'query layerservice vmap.n ? weight' )

# Get ID of mesh layer
fg = lx.eval1( 'query layerservice layers ? fg' )
fg_index = lx.eval( 'query layerservice layer.index ? fg' )
#lx.out( 'fg_index = %s' % fg_index )

# Change Edit Mode to vertex
lx.eval('select.type vertex')

if fg :

	# Get Selected Weight ID
	sel_wgt = []
	sel_wgtnum = 0

	if weight_lists :

		for wgt in weight_lists :

			if ( lx.eval( 'query layerservice vmap.selected ? %s' % wgt ) ) :

				sel_wgt.append( lx.eval( 'query layerservice vmap.index ? %s' % wgt ) )
				sel_wgtnum += 1

	# Drop Vertex
	lx.eval( 'select.drop vertex' )

	for i in range( 0, sel_wgtnum ):

		# Get Point Number
		pnt_lists = lx.eval( 'query layerservice verts ? all' )
		pnt_num = lx.eval( 'query layerservice vert.N ? all' )

		# Select Weight Map
		wgt_name = lx.eval( 'query layerservice vmap.name ? %s' % sel_wgt[ i ] )
		comstring = 'select.vertexMap ' + wgt_name + ' wght replace'
		lx.eval( comstring )

		clear_num = 0

		# Create Progress bar
		m = lx.Monitor()

		# Initialize Progress bar
		m.init( pnt_num )

		for pnt in pnt_lists :

			# Step Monitor
			m.step( 1 )

			# Get Weight Value of Each Vertex
			wgt_val = lx.eval( 'query layerservice vert.vmapValue ? %s' % pnt )
			lx.out( 'wgt_val = %s' % wgt_val )

			if ( ( wgt_val ) and ( abs( float( wgt_val ) ) < cutoff_val ) ):

				# Select Vertex
				pnt_index = lx.eval( 'query layerservice vert.index ? %s' % pnt )
				lx.eval( 'select.element %s vertex add %s' % ( fg_index, pnt_index ) )
#				lx.out( 'select.element %s vertex add %s' % ( fg_index, pnt_index ) )

				clear_num += 1

		# Clear Vertex
		if ( ( argsAsString == 'Clear' ) and ( clear_num > 0 ) ) :
			lx.eval( 'vertMap.clear wght' )

	# Drop Vertex
	if ( argsAsString == 'Clear' ):
		lx.eval( 'select.drop vertex' )


