#python

# Convert Skeleton Weights to normal Weights and Re-assign sletons
# Author MODO JAPAN GROUP
# version 1.0


import sys
import lx


#################################################################
# Function to check whether 'chkmap' is in 'wgt_names' or not
#		1 : exist ;  0 : not exist
#################################################################
def IsExistWeightMap( wgt_names, chkmap ):

	for each_map in wgt_names :
		if ( each_map == chkmap ) :
			return 1

	return 0


#################################################################
# Function to get index of skeleton
#		return -1 if  'idname' is not in lct_lists
#################################################################
def GetSkeletonIndex( lct_lists, idname ):

	index = 0
	for str_name in lct_lists :
		if ( str_name == idname ) :
			return index
		index += 1

	return -1


#################################################################
# Function to get index of deformer
#		return -1 if 'idname' is not in 'dfm_lists'
#################################################################
def GetDeformerIndex( dfm_lists, idname ):

	index = 0
	for str_name in dfm_lists :
		def_name = 'Transform : ' + idname + ' (Weight)'
		if ( str_name == def_name ) :
			return index
		index += 1

	return -1


#################################################################
#	Main function
#################################################################

#lx.out( "Python version:", sys.version )

### Get Skeleton and GenInfluence Information ###

# get item number in current scene
item_num = lx.eval( "query sceneservice item.N ?" )

# locator_names : locator display name
#			ex: Skeleton_Joint, Skeleton_Joint (2), ...
# locator_ids : locator internal name
#			ex : locator022, locator024, ...
locator_names = []
locator_ids = []

# deformer_names : deformer display name
#			ex: Transform : Skeleton_Joint (Weight), Transform : Skeleton_Joint (2) (Weight), ...
# deformer_ids : deformer internal name
#			ex: genInfluence035, genInfluence036, ...
deformer_names = []
deformer_ids = []

# scan all items in scene
for i in range( 0, item_num):

	# get item's display name, type, internal name, tagType
	com_string = "query sceneservice item.name ? " + str( i )
	item_name = lx.eval( com_string )
	com_string = "query sceneservice item.type ? " + str( i )
	item_type = lx.eval( com_string )
	com_string = "query sceneservice item.id ? " + str( i )
	item_id = lx.eval( com_string )
	com_string = "query sceneservice item.tagTypes ? " + str( i )
	item_tag = lx.eval( com_string )

	if ( item_type== "locator" ):

		# get locator display names and internal names in scene
		locator_names.append( item_name )
		locator_ids.append( item_id )

	elif ( item_type == "genInfluence" ):

		# get deformer display names and internal names in scene
		deformer_names.append( item_name )
		deformer_ids.append( item_id )

#lx.out( "locator number = %d" % len( locator_names ) )
#lx.out( "locator name = %s" % locator_names )
#lx.out( "locator id = %s" % locator_ids )
#lx.out( "deformer number = %d" % len( deformer_names ) )
#lx.out( "deformer name = %s" % deformer_names )
#lx.out( "deformer id = %s" % deformer_ids )


### Get Weight  Information ###
weight_num = lx.eval( "query layerservice vmap.N ? weight" )

if weight_num != 0:

    # Create Weight Map Name Lists
	wgt_maps = lx.eval( "query layerservice vmaps ? weight" )
	wgt_names = []

	for each_map in wgt_maps:

		com_string = "query layerservice vmap.type ? " + each_map
		map_type = lx.eval( com_string )
		com_string = "query layerservice vmap.name ? " + each_map
		map_name = lx.eval( com_string )
		wgt_names.append( map_name )

#	lx.out( "weight number = %d" % weight_num )
#	lx.out( "wgt_names = %s" % wgt_names )


	### Get Skeleton Weight  Information ###

	# original_skweight : __item_locator022, ...
	# new_skweight : Weight_Skeleton_Joint, ...
	original_skweight = []
	new_skweight = []
	sk_index = []

	pureLocators = lx.eval( "query sceneservice pureLocators ? ")
	for pL in pureLocators:

		# Create weight name from locator(skeleton) name
		wgt_name = "__item_" + pL

		# Check whether there is Skeleton's weight map or not
		isExist = IsExistWeightMap( wgt_names, wgt_name )

		# If exists
		if ( isExist ) :

			locator_index = GetSkeletonIndex( locator_ids, pL )

			if ( locator_index != -1 ):

				sk_index.append( locator_index )
				original_skweight.append( wgt_name )
				# create NEW weight name from locator(rig) name
				new_skweight.append(  "Weight_" + locator_names[ locator_index ] )


#	lx.out( "skweight number = %d" % len( original_skweight ) )
#	lx.out( "original skweight = %s" % original_skweight )
#	lx.out( "new skweight = %s" % new_skweight )
#	lx.out( "sk_index = %s" % sk_index )


	### Copy Original Skeleton Weight  ###

	i = 0
	for wgt in original_skweight :

		# select weight map
		com_string = 'select.vertexMap "' + original_skweight[ i ] + '" wght replace'
		chk = lx.eval( com_string )

		# copy selected map
		lx.eval( "vertMap.copy wght" )

		# create new weight map
		com_string = 'vertMap.new "' + new_skweight[ i ] + '" wght false {0.78 0.78 0.78} 1.0'
		lx.eval( com_string )

		# paste copied map into new map
		lx.eval( "vertMap.paste wght" )

		i += 1


	### Re-Assign General Influence Weight  ###

	i = 0
	for wgt in original_skweight :

			j = sk_index[ i ]
			deformer_index = GetDeformerIndex( deformer_names, locator_names[  j  ] )

			if ( deformer_index != -1 ):

				# Select General Influence
				com_string = 'select.deformer ' + deformer_ids[ deformer_index ] + ' set'
				lx.eval( com_string )

				# Select Weight Map
				com_string = 'genInfluence.name "' + new_skweight[  i  ] + '"'
				lx.eval( com_string )

			i += 1


	### Delete Original Skeleton Weight  ###

	for wgt in original_skweight :

		        # select weight map
				com_string = 'select.vertexMap "' + wgt + '" wght replace'
				chk = lx.eval( com_string )

				#delete weight map
				lx.eval( "!vertMap.delete wght" )

