#python

# Convert Polygons to PolyLines
# Author MODO JAPAN GROUP
# version 1.3


import sys
import lx


# Check Foreground Layer
fgnum = lx.eval( 'query layerservice layer.N ? fg' )
fglist = lx.evalN( 'query layerservice layers ? fg' )

if ( fgnum > 0 ):

	for fg in fglist:

		# Get Layer Name & ID
		layer_name = lx.eval( 'query layerservice layer.name ? %d' % fg )
		layer_id = lx.eval( 'query layerservice layer.id ? %d' % fg )
		lx.out( 'layer_name = %s, id = %s' % ( layer_name, layer_id ) )

		# Select each layer
		comstring = 'select.subItem ' + layer_id + ' set mesh 0 0'
		lx.eval( comstring )

		# Switch Edit Mode to Vertex & Copy selected all edges
		lx.eval( 'select.typeFrom edge' )
		lx.eval( 'select.edge add 0 all 0' )
		lx.eval( 'copy' )

		# Make New Layer
		lx.eval( 'layer.new' )

		# Rename New Layer
		comstring = 'item.name "PolyLine_' + layer_name + '" xfrmcore'
		lx.eval( comstring )

		# Paste edges
		lx.eval( 'paste' )

		# Convert Polygon Type from Face to Polyline
		lx.eval( 'poly.convert line face' )


