#python

# Convert From Curve to Skeleton
# Author MODO JAPAN GROUP
# version 1.0

import sys
import lx

# Get layer information
com_string = 'query layerservice layers ? fg'
layer = lx.eval( com_string )

com_string = 'query layerservice layer.id ? ' + str( layer )
layer_id = lx.eval( com_string )

# Locator Name Prefix
com_string = 'query layerservice layer.name ? ' + str( layer )
layer_name = lx.eval( com_string )
lx.out( layer_name )

loc_name_prefix = 'c2sk_' + layer_name + '_'
lx.out( loc_name_prefix )

# Get selected polygon information
poly_selnum = lx.eval( 'query layerservice poly.N ? selected' )
polys = lx.evalN( 'query layerservice polys ? selected' )

if polys:
	
	poly_count = 0

	for polyID in polys :

		# Get vertex count in polygon
		com_string = 'query layerservice poly.numVerts ? ' + polyID
		vert_num = lx.eval( com_string )

		# Get vertex ids in polygon
		com_string = 'query layerservice poly.vertList ? ' + polyID
		verts = lx.eval( com_string )
		
		ver_count = 0
		
		for vertID in verts :
			
			# Get vertex position
			com_string = 'query layerservice vert.pos ? ' + str( vertID )
			px, py, pz = lx.eval( com_string )

			# Make Locator
			lx.eval( 'item.create locator applyDefaultPreset:true' )
			
			# Position Locator
			com_string = "transform.channel pos.X " + str( px )
			lx.eval( com_string )
			com_string = "transform.channel pos.Y " + str( py )
			lx.eval( com_string )
			com_string = "transform.channel pos.Z " + str( pz )
			lx.eval( com_string )

			# Rename Locator
			com_string = 'item.name \"' + loc_name_prefix + str( poly_count ) + '_' + str( ver_count ) + '\" xfrmcore'
			lx.eval( com_string )
			lx.out( com_string )
			
			# Appearance Locator
			lx.eval( 'item.channel locator$link custom' )
			lx.eval( 'item.channel locator$lsShape rhombus' )
			lx.eval( 'item.channel locator$drawShape custom' )
			lx.eval( 'item.channel locator$isShape circle' )
			lx.eval( 'item.channel locator$isRadius 0.1' )
			lx.eval( 'item.channel locator$isAlign true' )
			lx.eval( 'item.channel locator$isSolid false' )
			
			# Select mesh layer
			com_string = 'select.subItem ' + layer_id + ' add mesh 0 0'
			lx.eval( com_string )
			
			# Set vertex constraint
			com_string = 'constraintGeometry vert pos'
			lx.eval( com_string )
			com_string = 'item.channel cmGeometryConstraint$indexA ' + str( vertID )
			lx.eval( com_string )
			
			ver_count += 1

		com_string = 'query sceneservice pureLocators ?'
		locator_ids = lx.eval( com_string )
		locator_num = len( locator_ids )
		
		ver_count = 0
		
		pid = cid = tmpid = 0
		
		for vertID in verts :
			
			# Locator Name
			loc_name = loc_name_prefix + str( poly_count ) + '_' + str( ver_count )

			tmpid = 0 
						
			# Search vert's locator
			for loc_id in locator_ids :
				
				com_string = 'query sceneservice item.name ? ' + loc_id
				loc_name_from_id = lx.eval( com_string )
				
				if ( loc_name_from_id == loc_name ) :
					
					tmpid = loc_id
					break
				
			if ( pid == 0 ) :
				
				pid = tmpid 
				
			else :
				
				cid = tmpid
				
				# Set parent
				com_string = 'item.parent ' + cid + ' ' + pid + ' 0 inPlace:1 duplicate:0'
				lx.eval( com_string )
					
				pid = cid
				
			ver_count += 1
			
		poly_count += 1
			
