#python

# Clear Selected Multiple Weight Maps
# Author MODO JAPAN GROUP
# version 1.0


import lx

#################################################################
#	Main function
#################################################################

# Get Weight Information
weight_lists = lx.eval( 'query layerservice vmaps ? weight' )
weight_num = lx.eval( 'query layerservice vmap.n ? weight' )

# Get ID of mesh layer
fg = lx.eval1( 'query layerservice layers ? fg' )
fg_index = lx.eval( 'query layerservice layer.index ? fg' )
#lx.out( 'fg_index = %s' % fg_index )

# Change Edit Mode to vertex
lx.eval('select.type vertex')

if fg :

	# Get Selected Weight ID
	sel_wgt = []
	sel_wgtnum = 0

	if weight_lists :

		for wgt in weight_lists :

			if ( lx.eval( 'query layerservice vmap.selected ? %s' % wgt ) ) :

				sel_wgt.append( lx.eval( 'query layerservice vmap.index ? %s' % wgt ) )
				sel_wgtnum += 1

		# Create Progress bar
		m = lx.Monitor()

		# Initialize Progress bar
		m.init( sel_wgtnum )

		for i in range ( 0, sel_wgtnum ):

			# Step Monitor
			m.step( 1 )

			# Select Weight Map
			wgt_name = lx.eval( 'query layerservice vmap.name ? %s' % sel_wgt[ i ] )
			comstring = 'select.vertexMap ' + wgt_name + ' wght replace'
			lx.eval( comstring )

			# Clear Weight
			comstring = 'vertMap.clear wght'
			lx.eval( comstring )

