#perl
# vertAlpha2Wgt.pl - Convert alpha from selected RGBA vert map to weightmap

my $mainLayer = lxq("query layerservice layers ? main");
my $poly=0;
my $vert=0, $nVerts = 0, $i, $vi, $rgbai;
my $AlphaWeightName = "AlphaWeight";
my $alpha_value;
my @verts, @norms, @vmaps;
my $nPols = lxq("query layerservice poly.n ? all");
my $nVerts = lxq("query layerservice vert.n ? all");
lxout("vertAlpha2Wgt");

# add new temp map and find index, new map is automatically selected
lx("vertMap.new $AlphaWeightName wght false");
@vmaps = lxq("query layerservice vmaps ?");
foreach my $vm (@vmaps) {
    my $name = lxq("query layerservice vmap.name ? $vm");
    if($name eq $AlphaWeightName) {
        $vi = $vm;
        #lx("select.vertexMap $name wght set");

        break;
    }
}

# Find selected RGBA map index, then deselect it
my $name;
@vmaps = lxq("query layerservice vmaps ? selected");
foreach my $vm (@vmaps) {
    my $type = lxq("query layerservice vmap.tag ? $vm");
    $name = lxq("query layerservice vmap.name ? $vm");
    #lxout ("$name $type");
    if($type eq "RGBA") {
        $rgbai = $vm;
        lx("select.vertexMap $name $type remove");
    }
}

#$nVerts = 0; # skip verts, just do discos!?
for($vrt=0; $vrt<$nVerts; $vrt++){
    lx("select.element $mainLayer vertex set $vrt");
    lxq("query layerservice vert.wpos ? $vrt");
    $name = lxq("query layerservice vmap.type ? $rgbai"); # set vertmap for query after element selection
    @RGBA = lxq("query layerservice vert.vmapValue ? $vrt");
    $alpha_value = @RGBA[3] ;
    lx("!vertMap.setVertex $AlphaWeightName weight 0 $vrt $alpha_value");
}

